/*
 * This file is a part of the xnetsentry project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include "exp_compil.h"
#include "exp_delete.h"

VOID_FUNC		delete_node_item(ni,deep)
t_node_item		*ni;
t_boolean		deep;
{
  node_item_delete(ni);
}

VOID_FUNC		delete_node_bop(nbop,deep)
t_node_bop		*nbop;
t_boolean		deep;
{
  if (deep)
    {
      delete_node(nbop->left,deep);
      delete_node(nbop->right,deep);
      delete_node_item(nbop->bop,deep);
    }
  node_bop_delete(nbop);
}

VOID_FUNC		delete_node_uop(nuop,deep)
t_node_uop		*nuop;
t_boolean		deep;
{
  if (deep)
    {
      delete_node(nuop->operand,deep);
      delete_node_item(nuop->uop,deep);
    }
  node_uop_delete(nuop);
}

VOID_FUNC		delete_node_func(nf,deep)
t_node_func		*nf;
t_boolean		deep;
{
  if (deep)
    {
      if (nf->params)
	delete_node(nf->params,deep);
      delete_node_item(nf->caller,deep);
    }
  node_func_delete(nf);
}

t_delete_proc		delete_procs[] =
{
  (t_delete_proc)delete_node_item,
  (t_delete_proc)delete_node_bop,
  (t_delete_proc)delete_node_uop,
  (t_delete_proc)delete_node_func
};

VOID_FUNC		delete_node(node,deep)
t_node			*node;
t_boolean		deep;
{
#ifdef DEBUG
  if (EXP_VERB(VERB_DELETE))
    fprintf(stderr,"delete_node: node=%p deep=%d\n",node,deep);
#endif
  assert(node->type < ARRAY_COUNT(delete_procs));
  delete_procs[node->type](node,deep);
}
