/*
 * This file is a part of the xnetsentry project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include "exp_class_int.h"

/*
 * ops
 */

#define BOPDEF(name,c_equiv) \
t_status		name(data,left,right,result)\
t_class_int_data	*data;\
t_object		*left;\
t_object		*right;\
t_object		**result;\
{\
   t_status		status;\
\
  if (((*result) = object_new(data->om,data->oid,&status)) == NULL)\
    return (status);\
  (*result)->value = (VOID_PTR)((int)(left->value) c_equiv \
				(int)(right->value));\
  return (0);\
}

BOPDEF(object_int_multiply,*)
BOPDEF(object_int_divide,/)
BOPDEF(object_int_modulus,%)
BOPDEF(object_int_plus,+)
BOPDEF(object_int_minus,-)
BOPDEF(object_int_left_shift,<<)
BOPDEF(object_int_right_shift,>>)
BOPDEF(object_int_less,<)
BOPDEF(object_int_less_or_equal,<=)
BOPDEF(object_int_greater,>)
BOPDEF(object_int_greater_or_equal,>=)
BOPDEF(object_int_equal,==)
BOPDEF(object_int_diff,!=)
BOPDEF(object_int_and,&)
BOPDEF(object_int_xor,^)
BOPDEF(object_int_or,|)
BOPDEF(object_int_logical_and,&&)
BOPDEF(object_int_logical_or,||)
#define COMMA ,
BOPDEF(object_int_comma,COMMA)

int			object_int_logical_and_is_contr(data,left,ok)
t_class_int_data	*data;
t_object		*left;
t_boolean		*ok;
{
  if (!(left->value))
    (*ok) = TRUE;
  else
    (*ok) = FALSE;
  return (0);
}

t_status		object_int_logical_and_contr(data,left,result)
t_class_int_data	*data;
t_object		*left;
t_object		**result;
{
  t_status		status;
  
  if (((*result) = object_new(data->om,data->oid,&status)) == NULL)
    return (status);
  (*result)->value = (VOID_PTR)(left->value && TRUE);
  return (0);
}

t_status		object_int_logical_or_is_contr(data,left,ok)
t_class_int_data	*data;
t_object		*left;
t_boolean		*ok;
{
  if (left->value)
    (*ok) = TRUE;
  else
    (*ok) = FALSE;
  return (0);
}

t_status		object_int_logical_or_contr(data,left,result)
t_class_int_data	*data;
t_object		*left;
t_object		**result;
{
  t_status		status;

  if (((*result) = object_new(data->om,data->oid,&status)) == NULL)
    return (status);
  (*result)->value = (VOID_PTR)(left->value || FALSE);
  return (0);
}

t_object_int_bop_def	object_int_bop_defs[] = 
{
  {"*",		12,	BOP_LEFT,
   NULL,NULL,(t_eval_bop_proc)object_int_multiply},
  {"/",		12,	BOP_LEFT,
   NULL,NULL,(t_eval_bop_proc)object_int_divide},
  {"%",		12,	BOP_LEFT,
   NULL,NULL,(t_eval_bop_proc)object_int_modulus},
  {"+",		11,	BOP_LEFT,
   NULL,NULL,(t_eval_bop_proc)object_int_plus},
  {"-",		11,	BOP_LEFT,
   NULL,NULL,(t_eval_bop_proc)object_int_minus},
  {"<<",	10,	BOP_LEFT,
   NULL,NULL,(t_eval_bop_proc)object_int_left_shift},
  {">>",	10,	BOP_LEFT,
   NULL,NULL,(t_eval_bop_proc)object_int_right_shift},
  {"<",		8,	BOP_LEFT,
   NULL,NULL,(t_eval_bop_proc)object_int_less},
  {"<=",	8,	BOP_LEFT,
   NULL,NULL,(t_eval_bop_proc)object_int_less_or_equal},
  {">",		8,	BOP_LEFT,
   NULL,NULL,(t_eval_bop_proc)object_int_greater},
  {">=",	8,	BOP_LEFT,
   NULL,NULL,(t_eval_bop_proc)object_int_greater_or_equal},
  {"==",	8,	BOP_LEFT,
   NULL,NULL,(t_eval_bop_proc)object_int_equal},
  {"!=",	8,	BOP_LEFT,
   NULL,NULL,(t_eval_bop_proc)object_int_diff},
  {"&",		7,	BOP_LEFT,
   NULL,NULL,(t_eval_bop_proc)object_int_and},
  {"^",		6,	BOP_LEFT,
   NULL,NULL,(t_eval_bop_proc)object_int_xor},
  {"|",		5,	BOP_LEFT,
   NULL,NULL,(t_eval_bop_proc)object_int_or},
  {"&&",	4,	BOP_LEFT,
   (t_eval_bop_is_contr_proc)object_int_logical_and_is_contr,
   (t_eval_bop_contr_proc)object_int_logical_and_contr,
   (t_eval_bop_proc)object_int_logical_and},
  {"||",	3,	BOP_LEFT,
   (t_eval_bop_is_contr_proc)object_int_logical_or_is_contr,
   (t_eval_bop_contr_proc)object_int_logical_or_contr,
   (t_eval_bop_proc)object_int_logical_or},
  {",",		0,	BOP_LEFT,
   NULL,NULL,(t_eval_bop_proc)object_int_comma}
};

#define UOPDEF(name,c_equiv) \
t_status		name(data,operand,result)\
t_class_int_data	*data;\
t_object		*operand;\
t_object		**result;\
{\
   t_status		status;\
\
  if (((*result) = object_new(data->om,data->oid,&status)) == NULL)\
    return (status);\
  (*result)->value = (VOID_PTR)(c_equiv (int)(operand->value));\
  return (0);\
}

UOPDEF(object_int_logical_not,!)
UOPDEF(object_int_not,~)
UOPDEF(object_int_unary_plus,+)
UOPDEF(object_int_unary_minus,-)

t_object_int_uop_def	object_int_uop_defs[] = 
{
  {"!",		-1,	UOP_PRE,
   (t_eval_uop_proc)object_int_logical_not},
  {"~",		-1,	UOP_PRE,
   (t_eval_uop_proc)object_int_not},
  {"+",		-1,	UOP_PRE,	
   (t_eval_uop_proc)object_int_unary_plus},
  {"-",		-1,	UOP_PRE,
   (t_eval_uop_proc)object_int_unary_minus}
};

/*
 * drivers
 */

t_boolean			object_int_sd_match(data,text,len,advice)
VOID_PTR			data;
char				*text;
int				len;
VOID_PTR			advice;
{
  return (uint_match(text));
}

t_status			object_int_eval(data,token,result)
t_class_int_data		*data;
t_token				*token;
t_object			**result;
{
  t_object			*o;
  t_status			status;

  if ((o = object_new(data->om,data->oid,&status)) == NULL)
    return (status);
  o->value = token->token_operand_value;
  (*result) = o;
  return (0);
}

t_status			object_int_sd_cvt(data,
						  text,
						  len,
						  advice,
						  token)
t_class_int_data		*data;
char				*text;
int				len;
VOID_PTR			advice;
t_token				*token;
{
  t_status			status;

  token->token_type = TOKEN_OPERAND;
  token->token_operand_value = (VOID_PTR)atoi(text);
  token->token_operand_eval.proc = (t_eval_item_proc)object_int_eval;
  token->token_operand_eval.data = (VOID_PTR)data;
  if (exp_keep_text)
    if ((token->token_show.text = strdup_alloc(text,
					       EXP_ALLOC_PROC,
					       "text",
					       &status)) == NULL)
      return (status);
  return (0);
}

/*
 * class
 */

VOID_FUNC			object_int_show(o)
t_object			*o;
{
  printf("%d",o->value);
}

VOID_FUNC			object_int_delete(o)
t_object			*o;
{
  /* NOP */
}

int				object_int_dup(src,dst)
t_object			*src;
t_object			*dst;
{
  dst->value = src->value;
  return (0);
}

t_object_def			object_int_def =
{
  OBJECT_INT_STR,
  object_int_show,
  object_int_delete,
  object_int_dup
};

int				object_int_sd_delete(delete_data,sd)
VOID_PTR			delete_data;
t_scan_drv			*sd;
{
  EXP_FREE_PROC(sd,"sd");
}

VOID_FUNC			class_int_tilde(data)
t_class_int_data		*data;
{
  EXP_FREE_PROC(data,"data");
}

t_status			class_int(om,data)
t_object_manager		*om;
t_class_int_data		**data;
{
  int				oid;
  int				i;
  t_status			status;
  t_scan_drv			*scan_drv;
  
  if (((*data) = EXP_ALLOC_PROC(sizeof (t_class_int_data),
			       "data",
			       &status)) == NULL)
    return (status);
  if ((oid = object_manager_register(om,&object_int_def)) < 0)
    {
      EXP_FREE_PROC(*data,"*data");
      return (oid);
    }
  (*data)->om = om;
  (*data)->oid = oid;
#ifdef DEBUG
  if (EXP_VERB(VERB_OBJ_INIT))
    fprintf(stderr,"object_int: oid=%d\n",oid);
#endif
  if ((scan_drv = EXP_ALLOC_PROC(sizeof (t_scan_drv),
				 "scan_drv",
				 &status)) == NULL)
    return (status);
  scan_drv->state = SCAN_STATE_DEFAULT;
  scan_drv->min_len = 1;
  scan_drv->max_len = 10;
  scan_drv->match = object_int_sd_match;
  scan_drv->match_data = NULL;
  scan_drv->cvt = (t_scan_drv_cvt_proc)object_int_sd_cvt;
  scan_drv->cvt_data = (VOID_PTR)(*data);
  scan_drv->delete = (t_scan_drv_delete_proc)object_int_sd_delete;
  if ((status = scan_add_drv(om->compil->scan,scan_drv)) < 0)
    return (status);
  i = 0;
  while (i < ARRAY_COUNT(object_int_bop_defs))
    {
      t_object_manager_bop	ombop;

      ombop.left_oid = oid;
      ombop.right_oid = oid;
      ombop.prio = object_int_bop_defs[i].prio;
      ombop.assoc = object_int_bop_defs[i].assoc;
      ombop.is_contr_proc = object_int_bop_defs[i].is_contr_proc;
      ombop.contr_proc = object_int_bop_defs[i].contr_proc;
      ombop.proc = object_int_bop_defs[i].proc;
      ombop.data = (VOID_PTR)(*data);
      if ((status = 
	   object_manager_request_bop(om,
				      object_int_bop_defs[i].pattern,
				      &ombop)) < 0)
	return (status);
      i++;
    }
  i = 0;
  while (i < ARRAY_COUNT(object_int_uop_defs))
    {
      t_object_manager_uop	omuop;

      omuop.operand_oid = oid;
      omuop.way = object_int_uop_defs[i].way;
      omuop.proc = object_int_uop_defs[i].proc;
      omuop.data = (VOID_PTR)(*data);
      if ((status = 
	   object_manager_request_uop(om,
				      object_int_uop_defs[i].pattern,
				      &omuop)) < 0)
	return (status);
      i++;
    }
  return (scan_setup_text(om->compil->scan,
			  scan_compute_text_len(om->compil->scan)));
}

t_class_def		class_int_def = 
{
  CLASS_INT_STR,
  (t_class_proc)class_int,
  (t_class_tilde_proc)class_int_tilde,
  NULL,
  NULL
};
