/*
 * This file is a part of the xnetsentry project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include <ctype.h>
#include "exp_class_base.h"

int			object_base_bop_comma(data,left,right,result)
t_object_manager	*data;
t_object		*left;
t_object		*right;
t_object		**result;
{
  return (object_dup(data,right,result));
}

t_boolean		class_base_space_sd_match(data,text,len,advice)
VOID_PTR		data;
char			*text;
int			len;
VOID_PTR		advice;
{
  return (len == 1 && isspace(text[0]));
}

t_boolean		class_base_lp_sd_match(data,text,len,advice)
VOID_PTR		data;
char			*text;
int			len;
VOID_PTR		advice;
{
  return (len == 1 && text[0] == '(');
}

int			class_base_lp_sd_cvt(data,text,len,advice,token)
VOID_PTR		data;
char			*text;
int			len;
VOID_PTR		advice;
t_token			*token;
{
  token->token_type = TOKEN_LP;
  return (0);
}

t_boolean		class_base_rp_sd_match(data,text,len,advice)
VOID_PTR		data;
char			*text;
int			len;
VOID_PTR		advice;
{
  return (len == 1 && text[0] == ')');
}

int			class_base_rp_sd_cvt(data,text,len,advice,token)
VOID_PTR		data;
char			*text;
int			len;
VOID_PTR		advice;
t_token			*token;
{
  token->token_type = TOKEN_RP;
  return (0);
}

t_status		class_base_space(om)
t_object_manager	*om;
{
  t_scan_drv		*scan_drv;
  t_status		status;

  if ((scan_drv = EXP_ALLOC_PROC(sizeof (t_scan_drv),
				 "scan_drv",
				 &status)) == NULL)
    return (status);
  scan_drv->state = SCAN_STATE_DEFAULT;
  scan_drv->min_len = 1;
  scan_drv->max_len = 1;
  scan_drv->match = class_base_space_sd_match;
  scan_drv->cvt = NULL;
  scan_drv->delete = scan_drv_sd_delete;
  if ((status = scan_add_drv(om->compil->scan,scan_drv)) < 0)
    return (status);
  return (0);
}

t_status		class_base_lp(om)
t_object_manager	*om;
{
  t_scan_drv		*scan_drv;
  t_status		status;

  if ((scan_drv = EXP_ALLOC_PROC(sizeof (t_scan_drv),
				 "scan_drv",
				 &status)) == NULL)
    return (status);
  scan_drv->state = SCAN_STATE_DEFAULT;
  scan_drv->min_len = 1;
  scan_drv->max_len = 1;
  scan_drv->match = class_base_lp_sd_match;
  scan_drv->cvt = (t_scan_drv_cvt_proc)class_base_lp_sd_cvt;
  scan_drv->delete = scan_drv_sd_delete;
  if ((status = scan_add_drv(om->compil->scan,scan_drv)) < 0)
    return (status);
  return (0);
}

t_status		class_base_rp(om)
t_object_manager	*om;
{
  t_scan_drv		*scan_drv;
  t_status		status;

  if ((scan_drv = EXP_ALLOC_PROC(sizeof (t_scan_drv),
				 "scan_drv",
				 &status)) == NULL)
    return (status);
  scan_drv->state = SCAN_STATE_DEFAULT;
  scan_drv->min_len = 1;
  scan_drv->max_len = 1;
  scan_drv->match = class_base_rp_sd_match;
  scan_drv->cvt = (t_scan_drv_cvt_proc)class_base_rp_sd_cvt;
  scan_drv->delete = scan_drv_sd_delete;
  if ((status = scan_add_drv(om->compil->scan,scan_drv)) < 0)
    return (status);
  return (0);
}

t_status		class_base_comma(om)
t_object_manager	*om;
{
  t_status		status;
  t_object_manager_bop	ombop;
  
  ombop.left_oid = OBJECT_ID_ANY;
  ombop.right_oid = OBJECT_ID_ANY;
  ombop.prio = 0;
  ombop.assoc = BOP_LEFT;
  ombop.is_contr_proc = NULL;
  ombop.contr_proc = NULL;
  ombop.proc = (t_eval_bop_proc)object_base_bop_comma;
  ombop.data = (VOID_PTR)om;
  if ((status = object_manager_request_bop(om,
					   ",",
					   &ombop)) < 0)
    return (status);
}

t_status		class_base_func_show(token,node,result)
t_token			*token;
t_node			*node;
VOID_PTR		*result;
{
  static t_object	o;
  t_status		status;
  t_class_base_data	*data;

  data = (t_class_base_data *)(token->token_data);
  if (node)
    if ((status = show_node(stderr,node,TRUE)) < 0)
      return (status);
  o.oid = data->void_oid;
  (*result) = &o; 
  return (0);
}

t_boolean		class_base_func_sd_match(func_data,text,len,advice)
t_func_data		*func_data;
char			*text;
int			len;
VOID_PTR		advice;
{
  return (!strcmp(text,func_data->name));
}

t_status		class_base_func_sd_cvt(func_data,text,len,advice,token)
t_func_data		*func_data;
char			*text;
int			len;
VOID_PTR		advice;
t_token			*token;
{
  t_status		status;

  token->token_type = TOKEN_OPERAND;
  token->token_operand_value = (VOID_PTR)(func_data->proc);
  token->token_operand_eval.proc = (t_eval_item_proc)object_ptrfunc_eval;
  token->token_operand_eval.data = (VOID_PTR)(func_data->class_base_data);
  token->token_data = (VOID_PTR)(func_data->data);
  if (exp_keep_text)
    if ((token->token_show.text = strdup_alloc(text,
					       EXP_ALLOC_PROC,
					       "text",
					       &status)) == NULL)
      return (status);
  return (0);
}

t_status			exp_register_func(class_base_data,
						  name,
						  proc,
						  data)
t_class_base_data		*class_base_data;
const char			*name;
t_eval_func_proc		proc;
VOID_PTR			data;
{
  t_scan_drv			*scan_drv;
  t_status			status;
  int				len;
  t_func_data			*func_data;

  if ((func_data = EXP_ALLOC_PROC(sizeof (t_func_data),
				  "func_data",
				  &status)) == NULL)
    return (status);
  if ((scan_drv = EXP_ALLOC_PROC(sizeof (t_scan_drv),
				 "scan_drv",
				 &status)) == NULL)
    {
      EXP_FREE_PROC(func_data,"func_data");
      return (status);
    }
  func_data->class_base_data = class_base_data;
  func_data->name = (char *)name;
  func_data->proc = proc;
  func_data->data = data;
  scan_drv->state = SCAN_STATE_DEFAULT;
  len = strlen(name);
  scan_drv->min_len = len;
  scan_drv->max_len = len;
  scan_drv->match = (t_scan_drv_match_proc)class_base_func_sd_match;
  scan_drv->match_data = (VOID_PTR)func_data;
  scan_drv->cvt = (t_scan_drv_cvt_proc)class_base_func_sd_cvt;
  scan_drv->cvt_data = (VOID_PTR)func_data;
  scan_drv->delete = scan_drv_sd_delete_free_data;
  scan_drv->delete_data = (VOID_PTR)func_data;
  if ((status = scan_add_drv(class_base_data->om->compil->scan,scan_drv)) < 0)
    return (status);
  return (0);
}

t_status			exp_func_node_to_vec(node,vec)
t_node				*node;
t_vec				*vec;
{
  t_status			status;
  VOID_PTR			result;

  if (node->type == NODE_BOP)
    {
      t_node_bop		*nbop;

      nbop = (t_node_bop *)node;
      if (nbop->bop->token->token_bop_eval.proc == 
	  (t_eval_bop_proc)object_manager_bop_eval)
	{
	  t_vec			*data;
	  t_object_manager_bop	*ombop;
	  
	  data = (t_vec *)(nbop->bop->token->token_bop_eval.data);
	  assert(VEC_COUNT(data) > 0);
	  ombop = (t_object_manager_bop *)(VEC_AT(data,0));
	  if (ombop->proc == (t_eval_bop_proc)object_base_bop_comma)
	    {
	      if ((status = eval_node(nbop->right,&result)) < 0)
		return (status);
	      if ((status = vec_add(vec,result)) < 0)
		return (status);
	      return (exp_func_node_to_vec(nbop->left,vec)); 
	    }
	}
    }
  if ((status = eval_node(node,&result)) < 0)
    return (status);
  if ((status = vec_add(vec,result)) < 0)
    return (status);
  return (0);
}

t_status			object_ptrfunc_eval(data,token,result)
t_class_base_data		*data;
t_token				*token;
t_object			**result;
{
  t_object			*o;
  t_status			status;

  if ((o = object_new(data->om,data->ptrfunc_oid,&status)) == NULL)
    return (status);
  o->value = token->token_operand_value;
  (*result) = o;
  return (0);
}

VOID_FUNC			object_ptrfunc_show(o)
t_object			*o;
{
  printf("%x",o->value);
}

VOID_FUNC			object_ptrfunc_delete(o)
t_object			*o;
{
  /* NOP */
}

int				object_ptrfunc_dup(src,dst)
t_object			*src;
t_object			*dst;
{
  dst->value = src->value;
  return (0);
}

t_object_def			object_ptrfunc_def =
{
  OBJECT_PTRFUNC_STR,
  object_ptrfunc_show,
  object_ptrfunc_delete,
  object_ptrfunc_dup
};

t_status			class_base_ptrfunc(data)
t_class_base_data		*data;
{
  t_status			status;

  if ((status = object_manager_register(data->om,
					&object_ptrfunc_def)) < 0)
    return (status);
  data->ptrfunc_oid = status;
  return (0);
}

t_status			object_void_eval(data,token,result)
t_class_base_data		*data;
t_token				*token;
t_object			**result;
{
  t_object			*o;
  t_status			status;

  if ((o = object_new(data->om,data->void_oid,&status)) == NULL)
    return (status);
  (*result) = o;
  return (0);
}

VOID_FUNC			object_void_show(o)
t_object			*o;
{
  printf("");
}

VOID_FUNC			object_void_delete(o)
t_object			*o;
{
  /* NOP */
}

t_status			object_void_dup(src,dst)
t_object			*src;
t_object			*dst;
{
  return (0);
}

t_object_def			object_void_def =
{
  OBJECT_VOID_STR,
  object_void_show,
  object_void_delete,
  object_void_dup
};

t_status			class_base_void(data)
t_class_base_data		*data;
{
  t_status			status;

  if ((status = object_manager_register(data->om,
					&object_void_def)) < 0)
    return (status);
  data->void_oid = status;
  return (0);
}

VOID_FUNC			class_base_tilde(data)
t_class_base_data		*data;
{
  EXP_FREE_PROC(data,"data");
}

t_status			class_base(om,data)
t_object_manager		*om;
t_class_base_data		**data;
{
  t_status			status;

  if (((*data) = EXP_ALLOC_PROC(sizeof (t_class_base_data),
				"data",
				&status)) == NULL)
    return (NULL);
  (*data)->om = om;
  if ((status = class_base_space(om)) < 0)
    return (status);
  if ((status = class_base_lp(om)) < 0)
    return (status);
  if ((status = class_base_rp(om)) < 0)
    return (status);
  if ((status = class_base_comma(om)) < 0)
    return (status);
  if ((status = class_base_ptrfunc(*data)) < 0)
    return (status);
  if ((status = class_base_void(*data)) < 0)
    return (status);
  if ((status = exp_register_func(*data,
				  "show",
				  class_base_func_show,
				  *data)) < 0)
    return (status);
  return (scan_setup_text(om->compil->scan,
			  scan_compute_text_len(om->compil->scan)));
}

t_class_def			class_base_def =
{
  CLASS_BASE_STR,
  (t_class_proc)class_base,
  (t_class_tilde_proc)class_base_tilde,
  NULL,
  NULL
};
