/*
 * This file is a part of the xnetsentry project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include "exp_class.h"

t_class_manager		*class_manager_new(om,status)
t_object_manager	*om;	
t_status		*status;
{
  t_class_manager	*cm;

  if ((cm = EXP_ALLOC_PROC(sizeof (t_class_manager),"cm",status)) == NULL)
    return (NULL);
  if ((cm->cids = EXP_VEC_NEW(status)) == NULL)
    {
      EXP_FREE_PROC(cm,"cm");
      return (NULL);
    }
  cm->om = om;
  return (cm);
}

VOID_FUNC		class_manager_delete(cm)
t_class_manager		*cm;
{
  vec_ptr_delete(cm->cids);
  EXP_FREE_PROC(cm,"cm");
}

t_status		class_manager_register(cm,cd)
t_class_manager		*cm;
t_class_def		*cd;
{
  t_class		*c;
  t_status		status;

  if ((c = EXP_ALLOC_PROC(sizeof (t_class),"c",&status)) == NULL)
    return (status);
  c->def = cd;
  return (vec_add(cm->cids,c)); 
}

t_class			*class_get_from_name(cm,name,status)
t_class_manager		*cm;
char			*name;
t_status		*status;
{
  VEC_FOR(cm->cids,t_class *c)
    {
      if (!strcmp(c->def->name,name))
	return (c);
    }
  VEC_ENDFOR;
  (*status) = -ERR_NOENT;
  return (NULL);
}

int			class_manager(cm)
t_class_manager		*cm;
{
  int			status;

  VEC_FOR(cm->cids,t_class *c)
    {
      if ((status = c->def->class(cm->om,&(c->data))) < 0)
	return (status);
    }
  VEC_ENDFOR;
  return (0);
}

VOID_FUNC		class_manager_tilde(cm)
t_class_manager		*cm;
{
  int			status;

  VEC_FOR(cm->cids,t_class *c)
    {
      if (c->def->class_tilde)
	c->def->class_tilde(c->data);
    }
  VEC_ENDFOR;
}

VOID_FUNC		class_manager_pool_destroy(cm)
t_class_manager		*cm;
{
  int			status;

  VEC_FOR(cm->cids,t_class *c)
    {
      if (c->def->pool_destroy)
	c->def->pool_destroy(c->data);
    }
  VEC_ENDFOR;
}

VOID_FUNC		class_manager_pool_empty(cm)
t_class_manager		*cm;
{
  int			status;

  VEC_FOR(cm->cids,t_class *c)
    {
      if (c->def->pool_empty)
	c->def->pool_empty(c->data);
    }
  VEC_ENDFOR;
}
