/*
 * This file is a part of the xnetsentry project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include "exp.h"

t_boolean		exp_keep_text = FALSE;

#ifdef DEBUG
t_mask			exp_verb_level;

t_mask_def		exp_verb_level_defs[] = 
{
  {"obj_init",		VERB_OBJ_INIT},
  {"compil",		VERB_COMPIL},
  {"scan",		VERB_SCAN},
  {"delete",		VERB_DELETE},
  {"eval",		VERB_EVAL},
  {"obj",		VERB_OBJ},
  {"all",		~0L},
  {NULL,		0}
};

VOID_FUNC		exp_debug_init(VOID_DECL)
{
  char			*str;

  if (str = getenv("EXP_VERB_LEVEL"))
    {
      t_vec		*vec;
      t_status		status;

      vec = EXP_VEC_NEW(&status);
      assert(vec);
      if ((status = vec_str_split(vec,str,'|')) < 0)
	{
	  err_print(-status,"exp_debug_init");
	  abort();
	}
      if ((status = mask_from_vec_str(exp_verb_level_defs,
				      vec,
				      &exp_verb_level)) < 0)
	{
	  err_print(-status,"exp_debug_init");
	  abort();
	}
      vec_str_delete(vec);
    }
  if (str = getenv("EXP_KEEP_TEXT"))
    {
      exp_keep_text = atobooleanfalse(str);
    }
}
#endif
