/*
 * This file is a part of the xnetsentry project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <windows.h>
#include <errno.h>
#include "nt_dirent.h"

int			sleep(x)
int			x;
{
   Sleep(x*1000);
}

DIR			*opendir(a_dir)
char			*a_dir;
{
   int			err;
   WIN32_FIND_DATA	wfd;
   DIR			*dd_dir;
   char			*c_dir;

   dd_dir = (DIR *) malloc (sizeof(DIR));
   c_dir = malloc (strlen(a_dir) + 4);
   strcpy (c_dir, a_dir);
   strcat (c_dir, "\\*");
   dd_dir->d_handle = FindFirstFile (c_dir, &wfd);
   if (dd_dir->d_handle == INVALID_HANDLE_VALUE)	
   {
      err = GetLastError();
      switch (err) 
      {
      case ERROR_NO_MORE_FILES:
      case ERROR_FILE_NOT_FOUND:
      case ERROR_PATH_NOT_FOUND:
	 errno = ENOENT;
	 break;
      case ERROR_NOT_ENOUGH_MEMORY:
	 errno = ENOMEM;
	 break;
      default:
	 errno = EINVAL;
	 break;
      }
      FREE(dd_dir,"dd_dir");
      return NULL;
   }
   dd_dir->d_attr = (wfd.dwFileAttributes == FILE_ATTRIBUTE_NORMAL)
      ? 0 : wfd.dwFileAttributes;
   dd_dir->d_time = dd_dir->d_date = 10;
      dd_dir->d_size = wfd.nFileSizeLow;
   strcpy(dd_dir->d_name, wfd.cFileName);
   dd_dir->d_first = 1;
   FREE(c_dir,"c_dir");
   return (dd_dir);
}

DIR			*readdir(dd_dir)
DIR			*dd_dir;
{
   int			err;
   WIN32_FIND_DATA	wfd;
	
   if (dd_dir->d_first) 
   {
      dd_dir->d_first = 0;
      return dd_dir;
   }
   if (!FindNextFile (dd_dir->d_handle, &wfd)) 
   {
      err = GetLastError();
      switch (err) 
      {
      case ERROR_NO_MORE_FILES:
      case ERROR_FILE_NOT_FOUND:
      case ERROR_PATH_NOT_FOUND:
	 errno = ENOENT;
	 break;
      case ERROR_NOT_ENOUGH_MEMORY:
	 errno = ENOMEM;
	 break;
      default:
	 errno = EINVAL;
	 break;
      }
      return NULL;
   }
   dd_dir->d_attr = (wfd.dwFileAttributes == FILE_ATTRIBUTE_NORMAL)
      ? 0 : wfd.dwFileAttributes;
   dd_dir->d_time = dd_dir->d_date = 10;
   dd_dir->d_size = wfd.nFileSizeLow;
   strcpy (dd_dir->d_name, wfd.cFileName);
   return (dd_dir);
}		  

int			closedir(dd_dir)
DIR			*dd_dir;
{
   FindClose(dd_dir->d_handle);
   free (dd_dir);
}
