/*
 * This file is a part of the xnetsentry project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#ifndef NT_DIRENT_H
#define NT_DIRENT_H

#ifdef __WATCOMC__
# include <direct.h>
#else
#ifdef __cplupplus
extern "C" {
#endif

#include <sys/types.h>

#define NAME_MAX	255

typedef struct		dirent 
{
   void*		d_handle;
   unsigned		d_attr;			/* file's attribute */
   unsigned short int	d_time;			/* file's time */
   unsigned short int	d_date;			/* file's date */
   long			d_size;			/* file's size */
   char			d_name[NAME_MAX+1];	/* file's name */
   unsigned short	d_ino;			/* serial number (not used) */
   char			d_first;		/* flag for 1st time */
} DIR;

#ifndef _A_NORMAL
#define _A_NORMAL       0x00    /* Normal file - read/write permitted */
#define _A_RDONLY       0x01    /* Read-only file */
#define _A_HIDDEN       0x02    /* Hidden file */
#define _A_SYSTEM       0x04    /* System file */
#define _A_VOLID        0x08    /* Volume-ID entry */
#define _A_SUBDIR       0x10    /* Subdirectory */
#define _A_ARCH         0x20    /* Archive file */
#endif /* _A_NORMAL_ */

extern int		closedir(DIR *);
extern DIR		*opendir(char *);
extern struct dirent	*readdir(DIR *);

#ifdef __cplusplus
};
#endif
#endif  /* __WATCOMC__ */
#endif
