/*
 * This file is a part of the xnetsentry project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#ifndef A_VEC_H
#define A_VEC_H	1

#include "a.h"

#define VEC_BASE		32

typedef struct			s_vec
{
  int				base;
  int				count;
  int				allocated;
  VOID_PTR			*elts;
  t_alloc_algorithm_proc	alloc_algorithm_proc;
  t_alloc_proc			alloc_proc;
  t_free_proc			free_proc;
} t_vec;

typedef int	(*t_vec_cmp_proc) P((const VOID_PTR p1,
				     const VOID_PTR p2));

#define VEC_NEW(statusp)	vec_new(VEC_BASE,\
					FALSE,\
					alloc_algorithm_power2,\
					alloc_malloc,\
					free_free,\
					(statusp))

#define VEC_FOR(vec,var)	{int _vec_idx;\
  for(_vec_idx = 0;_vec_idx < (vec)->count;_vec_idx++)\
    {var = (vec)->elts[_vec_idx];
#define VEC_FOR_FROM(vec,from,var)	{int _vec_idx;\
       for(_vec_idx = (from);_vec_idx < (vec)->count;_vec_idx++)\
	 {var = (vec)->elts[_vec_idx];
#define VEC_IDX			_vec_idx
#define VEC_REWIND		(_vec_idx = 0)
#define VEC_ITEM(vec)		(vec)->elts[_vec_idx]
#define VEC_ENDFOR		}}
#define VEC_RM_ELT(vec,elt)	vec_rm((vec),vec_index((vec),(elt)))
#define VEC_COUNT(vec)		((vec)->count)
#define VEC_AT(vec,idx)		((vec)->elts[(idx)])
#define VEC_AT_MODULO(vec,idx)	((vec)->elts[(idx) % (vec)->count])
#define VEC_FIRST_ELT(vec)	(VEC_AT((vec),0))
#define VEC_LAST_ELT(vec)	(VEC_AT((vec),VEC_COUNT(vec) - 1))
#define VEC_BEFORE_LAST_ELT(vec)	(VEC_AT((vec),\
						 VEC_COUNT(vec) - 2))
#define VEC_RM_FIRST_ELT(vec)	(vec_rm((vec),0))
#define VEC_RM_LAST_ELT(vec)	(vec_rm((vec),VEC_COUNT(vec) - 1))
#define VEC_OVERRIDE(vec,idx,elt)	((vec)->elts[(idx)] = (elt))
#define VEC_ZERO_ELT(vec,idx)	((vec)->elts[(idx)] = NULL)

/* PROTO a_vec.c */
/* a_vec.c */
t_status vec_alloc P((t_vec *vec, int n));
t_vec *vec_new P((int base, t_boolean now, t_alloc_algorithm_proc alloc_algorithm_proc, t_alloc_proc alloc_proc, t_free_proc free_proc, t_status *status));
void vec_destroy P((t_vec *vec));
void vec_delete P((t_vec *vec));
int vec_add P((t_vec *vec, void *elt));
void vec_rm P((t_vec *vec, int idx));
int vec_index P((t_vec *vec, void *elt));
void vec_reverse P((t_vec *vec));
void vec_sort P((t_vec *vec, t_vec_cmp_proc cmp));
void vec_show P((t_vec *vec));
#endif
