/*
 * This file is a part of the xnetsentry project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#ifndef A_OPT_H
#define A_OPT_H	1

#include "a.h"

struct s_opt_context;

#define OPT_ALLOWMULTI		(1L<<0)		

typedef int			(*t_opt_proc) P((struct s_opt_context *oc,
						 int idx,
						 VOID_PTR addr));
						 
typedef struct			s_opt
{
  char				*name;
  t_opt_proc			proc;
  off_t				offset;
  char				*param_comment;
  char				*comment;
  t_mask			flags;
} t_opt;

typedef struct			s_opt_context
{
  t_boolean			*tr_args;	/* MUST BE SET		*/
  int				nb_tr_args;	/* MUST BE SET		*/
  t_boolean			*tr_opts;	/* MUST BE SET		*/
  int				nb_tr_opts;	/* MUST BE SET		*/
  int				*argc;		/* MUST BE SET		*/
  char				**argv;		/* MUST BE SET		*/
  t_opt				*opts;		/* MUST BE SET		*/
  int				nb_opts;	/* MUST BE SET		*/
  char				*base_addr;	/* MUST BE SET		*/
} t_opt_context;

/* PROTO a_opt.c */
/* a_opt.c */
int opt_is_arg P((t_opt_context *oc, int idx, char **addr));
int opt_true P((t_opt_context *oc, int idx, t_boolean *addr));
int opt_false P((t_opt_context *oc, int idx, t_boolean *addr));
int opt_str P((t_opt_context *oc, int idx, char **addr));
int opt_int P((t_opt_context *oc, int idx, int *addr));
int opt_tr_args_matched P((t_opt_context *oc));
void opt_build_new_args P((t_opt_context *oc, int matched));
t_status opt_init_tr_args P((t_opt_context *oc));
t_status opt_init_tr_opts P((t_opt_context *oc));
t_status opt_get P((t_opt_context *oc));
void opt_usage P((FILE *f, t_opt *opts, int nb_opts, t_boolean full_usage));
int opt_check P((t_opt *opts, int nb_opts));
#endif
