/*
 * This file is a part of the xnetsentry project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#ifndef A_DICT_H
#define A_DICT_H	1

#include "a.h"

typedef t_hash_code		(*t_dict_hcode_proc) P((char *buf,
							int len));

typedef struct			s_dict
{
  t_vec				*ht;
  t_dict_hcode_proc		hcode_proc;
} t_dict;

typedef t_status		(*t_dict_walk_proc) P((t_hash_elt *he,
						       VOID_PTR data));

#define DICT_NEW(statusp)	dict_new(HASH_BASE,\
					 VEC_BASE,\
					 dict_hcode_public,\
					 alloc_algorithm_power2,\
					 alloc_malloc,\
					 free_free,\
					 (statusp))

/*
** You have to delete "value" before/after calling dict_rm()
*/

/* PROTO a_dict.c */
/* a_dict.c */
t_hash_code dict_hcode_dragon P((char *buf, int len));
t_hash_code dict_hcode_public P((char *buf, int len));
t_hash_code dict_hcode_gst P((char *buf, int len));
t_dict *dict_new P((int base, int list_base, t_dict_hcode_proc hcode_proc, t_alloc_algorithm_proc alloc_algorithm_proc, t_alloc_proc alloc_proc, t_free_proc free_proc, t_status *status));
void dict_destroy_elt P((t_hash_elt *he, t_dict *dict));
void dict_destroy P((t_dict *dict));
void dict_delete P((t_dict *dict));
t_hash_elt *dict_get P((t_dict *dict, char *key));
char *dict_key_dup P((t_dict *dict, char *key, t_status *status));
t_status dict_add P((t_dict *dict, char *key, void *value));
t_status dict_override P((t_dict *dict, char *key, void *value));
t_status dict_rm P((t_dict *dict, char *key));
t_boolean dict_is_empty P((t_dict *dict));
int dict_count P((t_dict *dict));
t_status dict_walk P((t_dict *dict, t_dict_walk_proc proc, void *data));
t_status dict_to_vec_hash_elt P((t_dict *dict, t_vec *vec));
t_status dict_walk_sorted_cmp P((t_dict *dict, t_dict_walk_proc walk_proc, t_vec_cmp_proc cmp_proc, void *data));
int dict_walk_sorted_cmp_cb P((void **p1, void **p2));
t_status dict_walk_sorted P((t_dict *dict, t_dict_walk_proc walk_proc, void *data));
t_status dict_max_len_cb P((t_hash_elt *he, int *max_len));
int dict_max_len P((t_dict *dict, t_status *status));
t_status dict_show_cb P((t_hash_elt *he, void *unused));
void dict_show P((t_dict *dict));
void dict_show_sorted P((t_dict *dict));
#endif
