/*
 * This file is a part of the xnetsentry project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#ifndef A_ALLOC_H
#define A_ALLOC_H	1

#include "a.h"

#ifdef DEBUG_MALLOC
VOID_PTR		real_malloc P((size_t size));
VOID_FUNC		real_free P((VOID_PTR ptr));

typedef struct		s_debug_malloc_elt
{
  VOID_PTR		ptr;
  size_t		size;
  int			id;
  char			*file;
  int			line;
  char			*comment;
} t_debug_malloc_elt;

extern int		debug_malloc_total;
extern int		debug_malloc_calls;
extern int		debug_malloc_calls_ok;
extern int		debug_malloc_ident;
extern t_id		*debug_malloc_id;
#endif

/* PROTO a_alloc.c */
/* a_alloc.c */
void alloc_algorithm_status P((void));
t_status alloc_algorithm_exact P((size_t eltsize, int base_count, int old_count, int new_count, size_t *real_size));
t_status alloc_algorithm_power2 P((size_t eltsize, int base_count, int old_count, int new_count, size_t *real_size));
void *alloc_malloc P((size_t size, char *comment, t_status *status));
void free_free P((void *ptr, char *comment));
void *alloc_real_malloc P((size_t size, char *comment, t_status *status));
void free_real_free P((void *ptr, char *comment));
t_status debug_malloc_init P((void));
void debug_malloc_destroy P((void));
void debug_malloc_elt_show P((t_debug_malloc_elt *dme));
t_status debug_malloc_status_cb P((t_hash_elt *he, int after));
int debug_malloc_status_cmp P((void **p1, void **p2));
void debug_malloc_status P((int after));
void *malloc_comment P((size_t size, char *file, int line, char *comment));
void *malloc P((size_t size));
void *realloc P((void *old_ptr, size_t size));
void free_comment P((void *ptr, char *comment));
void free P((void *ptr));
#endif
