/*
 * This file is a part of the xnetsentry project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include <ctype.h>
#include "a.h"

/* DICT_STR */
t_status		parse_vars(fd,sep,dict,proc)
int			fd;
int			sep;
t_dict			*dict;
t_dict_str_add_proc	proc;
{
  t_boolean		backslash;
  char			name[BUFSIZ];
  char			value[BUFSIZ];
  char			*current;
  t_boolean		comment;
  t_boolean		quote;
  t_status		status;

  quote = FALSE;
  backslash = FALSE;
  comment = FALSE;
  current = name;
  name[0] = 0;
  value[0] = 0;
  while (1)
    {
      char		buf[BUFSIZ];
      int		cc;
      int		i;	

      if ((cc = read(fd,buf,sizeof (buf))) < 0)
	return (-ERR_READ);
      if (cc == 0)
	return (0);
      i = 0;
      while (i < cc)
	{
	  char		c;

	  c = buf[i];
	  if (comment)
	    {
	      if (c == '\n')
		comment = FALSE;
	      else
		i++;
	      continue ;
	    }
	  if (backslash)
	    {
	      if (c == 'n')
		c = '\n';
	      else
		if (c == 'r')
		  c = '\r';
		else
		  if (c == 't')
		    c = '\t';
	      if ((status = str_cat_char(current,BUFSIZ,c)) < 0)
		return (status);
	      backslash = FALSE;
	      i++;
	      continue ;
	    }
	  if (c == '\\')
	    {
	      backslash = TRUE;
	      i++;
	      continue ;
	    }
	  if (quote)
	    {
	      if (c == '"')
		quote = FALSE;
	      else
		if ((status = str_cat_char(current,BUFSIZ,c)) < 0)
		  return (status);
	      i++;
	      continue ;
	    }
	  if (c == '"')
	    {
	      quote = TRUE;
	      i++;
	      continue ;
	    }
	  if (c == '#')
	    {
	      comment = TRUE;
	      i++;
	      continue ;
	    }
	  if (current != value)
	    if (c == sep)
	      {
		current = value;
		i++;
		continue ;
	      }
	  if (c == ' ' || c == '\t')
	    {
	      i++;
	      continue ;
	    }
	  if (c == '\n')
	    {
	      if (name[0] != 0)
		if ((status = proc(dict,name,value)) < 0)
		  return (status);
	      name[0] = 0;
	      value[0] = 0;
	      current = name;
	      i++;
	      continue ;
	    }
	  if ((status = str_cat_char(current,BUFSIZ,c)) < 0)
	    return (status);
	  i++;
	}
    }
  return (0);
}

t_status		parse_lines_init(plc)
t_parse_lines_context	*plc;
{
  t_status		status;
  
  assert(plc->vec && plc->wordbuf && plc->wordseps && plc->lineseps);
  plc->comment = FALSE;
  if ((plc->subvec = vec_new(VEC_BASE,
			     FALSE,
			     plc->vec->alloc_algorithm_proc,
			     plc->vec->alloc_proc,
			     plc->vec->free_proc,
			     &status)) == NULL)
    return (status);
  plc->wordbuf[0] = 0;
  return (0);
}

t_status		parse_lines_finnish(plc)
t_parse_lines_context	*plc;
{
  t_status		status;

  if (plc->wordbuf[0] != 0)
    {
      if ((status = vec_str_add(plc->subvec,
				plc->wordbuf)) < 0)
	return (status);
    }
  if (VEC_COUNT(plc->subvec) == 0)
    vec_str_delete(plc->subvec);
  else
    if ((status = vec_add(plc->vec,plc->subvec)) < 0)
	return (status);
  return (0);
}

/* VEC_VEC_STR */
t_status		parse_lines(plc,buf,len)
t_parse_lines_context	*plc;
char			*buf;
int			len;
{
  t_status		status;
  int			i;
  
  i = 0;
  while (i < len)
    {
      if (plc->comment)
	{
	  if (buf[i] == '\n')
	    plc->comment = FALSE;
	  else
	    i++;
	  continue ;
	}
      if (buf[i] == '#')
	{
	  plc->comment = TRUE;
	  i++;
	  continue ;
	}
      if (index(plc->wordseps,buf[i]))
	{
	  if (plc->wordbuf[0] == 0)
	    {
	      i++;
	      continue ;
	    }
	  if ((status = vec_str_add(plc->subvec,plc->wordbuf)) < 0)
	    return (status);
	  plc->wordbuf[0] = 0;
	}
      else
	if (index(plc->lineseps,buf[i]))
	  {
	    if (plc->wordbuf[0] != 0)
	      {
		if ((status = vec_str_add(plc->subvec,
					  plc->wordbuf)) < 0)
		  return (status);
		plc->wordbuf[0] = 0;
	      }
	    if (VEC_COUNT(plc->subvec) == 0)
	      {
		i++;
		continue ;
	      }
	    if ((status = vec_add(plc->vec,plc->subvec)) < 0)
	      return (status);
	    if ((plc->subvec = vec_new(VEC_BASE,
				       FALSE,
				       plc->vec->alloc_algorithm_proc,
				       plc->vec->alloc_proc,
				       plc->vec->free_proc,
				       &status)) == NULL)
	      return (status);
	  }
	else
	  if ((status = str_cat_char(plc->wordbuf,plc->wordbuflen,
				     buf[i])) < 0)
	    return (status);
      i++;
    }
  return (0);
}

t_status			bufferize_init(bc)
t_bufferize_context		*bc;
{
  t_status			status;

  if ((bc->vec_buf = VEC_NEW(&status)) == NULL)
    return (status);
  bc->len = 0;
  return (0);
}

VOID_FUNC			bufferize_destroy(bc)
t_bufferize_context		*bc;
{
  vec_buf_delete(bc->vec_buf);
}

char				*get_next_line(bc,status)
t_bufferize_context		*bc;
t_status			*status;
{
  char				*str;

  while (1)
    {
      char			*ptr;

      if (bc->len == 0)
	if ((bc->len = read(bc->fd,bc->buf,bc->buflen)) < 0)
	  {
	    (*status) = -ERR_READ;
	    return (NULL);
	  }
      if (bc->len == 0)
	{
	  (*status) = 0;
	  return (NULL);
	}
      if (ptr = bindex(bc->buf,bc->len,'\n'))
	{
	  int			newlen;
	  
	  if (((*status) = vec_buf_add(bc->vec_buf,
				       bc->buf,
				       ptr - bc->buf)) < 0)
	    return (NULL);
	  if ((str = vec_buf_str(bc->vec_buf,status)) == NULL)
	    return (NULL);
	  vec_buf_destroy(bc->vec_buf);
	  ptr++;
	  if ((newlen = bc->len - (ptr - bc->buf)) > 0)
	    {
	      bcopy(ptr,bc->buf,newlen);
	      bc->len = newlen;
	      return (str);
	    }
	  bc->len = 0;
	  return (str);
	}
      else
	{
	  if (((*status) = vec_buf_add(bc->vec_buf,bc->buf,bc->len)) < 0)
	    return (NULL);
	  bc->len = 0;
	}
    }
}

t_status			bufferize(bc)
t_bufferize_context		*bc;
{
  char				*str;
  t_status			status;

  while (1)
    {
      char			*ptr;

      if ((bc->len = read(bc->fd,bc->buf,bc->buflen)) < 0)
	return (-ERR_READ);
      if (bc->len == 0)
	return (0);
      if ((status = vec_buf_add(bc->vec_buf,bc->buf,bc->len)) < 0)
	return (status);
    }
}

t_status		tmpl_context_init(tc)
t_tmpl_context		*tc;
{
  tc->varbuf[0] = 0;
  tc->invar = FALSE;
  tc->varlen = 0;
  return (0);
}

t_status		tmpl_finnish(tc)
t_tmpl_context		*tc;
{
  if (tc->varlen != 0)
    return (-ERR_BADMATCH);
  return (0);
}

t_status		tmpl_replace(tc,buf,len)
t_tmpl_context		*tc;
char			*buf;
int			len;
{
  int			i;
  t_status		status;

  i = 0;
  while (i < len)
    {
      char		c;
      
      c = buf[i];
      if (tc->invar)
	{
	  if (c == tc->right_sep)
	    {
	      tc->varbuf[tc->varlen] = 0;
	      tc->varlen = 0;
	      tc->invar = FALSE;
	      if ((status = tc->do_proc(tc->do_data,tc->varbuf,tc->data)) < 0)
		return (status);
	      i++;
	      continue ;
	    }
	  else
	    {
	      if (tc->varlen < tc->varbuflen)
		tc->varbuf[(tc->varlen)++] = c;
	      else
		return (-ERR_BO);
	    }
	}
      else
	{
	  if (c == tc->left_sep)
	    {
	      tc->invar = TRUE;
	      i++;
	      continue ;
	    }
	  else
	    {
	      if ((status = tc->write_proc(tc->write_data,&c,1,tc->data)) < 0)
		return (0);
	    }
	}
      i++;
    }
  return (0);
}

/* CONVENIENCE ROUTINES */
t_status		tmpl_str_write(bs,buf,len,data)
t_bridled_str		*bs;
char			*buf;
int			len;
VOID_PTR		data;
{
  return (str_cat_buf(bs->str,bs->max_len,buf,len));
}

t_status		tmpl_str_to_str(tmpl,do_proc,data,str,max_len)
char			*tmpl;
t_tmpl_do_proc		do_proc;
VOID_PTR		data;
char			*str;
int			max_len;
{
  char			varbuf[STR_BUFSIZ];
  t_tmpl_context	tc;
  t_bridled_str		bs;
  t_status		status;

  bs.str = str;
  bs.max_len = max_len;
  tc.varbuf = varbuf;
  tc.varbuflen = sizeof (varbuf);
  tc.left_sep = '%';
  tc.right_sep = '%';
  tc.do_proc = (t_tmpl_do_proc)do_proc;
  tc.do_data = (VOID_PTR)(&bs);
  tc.write_proc = (t_tmpl_write_proc)tmpl_str_write;
  tc.write_data = (VOID_PTR)(&bs);
  tc.data = data;
  if ((status = tmpl_context_init(&tc)) < 0)
    return (status);
  if ((status = tmpl_replace(&tc,tmpl,strlen(tmpl))) < 0)
    return (status);
  if ((status = tmpl_finnish(&tc)) < 0)
    return (status);
  return (0);
}

t_status		tmpl_file_write(ofile,buf,len,data)
FILE			*ofile;
char			*buf;
int			len;
VOID_PTR		data;
{
  return (fwrite(buf,sizeof (char),len,ofile));
}

t_status		tmpl_file_to_file(ifile,do_proc,data,ofile)
FILE			*ifile;
t_tmpl_do_proc		do_proc;
VOID_PTR		data;
FILE			*ofile;
{
  char			varbuf[STR_BUFSIZ];
  t_tmpl_context	tc;
  t_status		status;

  tc.varbuf = varbuf;
  tc.varbuflen = sizeof (varbuf);
  tc.left_sep = '%';
  tc.right_sep = '%';
  tc.do_proc = (t_tmpl_do_proc)do_proc;
  tc.do_data = (VOID_PTR)ofile;
  tc.write_proc = (t_tmpl_write_proc)tmpl_file_write;
  tc.write_data = (VOID_PTR)ofile;
  tc.data = data;
  if ((status = tmpl_context_init(&tc)) < 0)
    return (status);
  while (!feof(ifile))
    {
      int		c;
      char		c2;

      c = fgetc(ifile);
      if (c == -1)
	break ;
      c2 = c;
      if ((status = tmpl_replace(&tc,&c2,1)) < 0)
	return (status);
    }
  if ((status = tmpl_finnish(&tc)) < 0)
    return (status);
  return (0);
}
