/*
 * This file is a part of the xnetsentry project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include <stdio.h>
#include "a.h"

int			opt_is_arg(oc,idx,addr)
t_opt_context		*oc;
int			idx;
char			**addr;
{
  (*addr) = oc->argv[idx];
  oc->tr_args[idx] = TRUE;
  return (1);
}

int			opt_true(oc,idx,addr)
t_opt_context		*oc;
int			idx;
t_boolean		*addr;
{
  (*addr) = TRUE;
  oc->tr_args[idx] = TRUE;
  return (1);
}

int			opt_false(oc,idx,addr)
t_opt_context		*oc;
int			idx;
t_boolean		*addr;
{
  (*addr) = FALSE;
  oc->tr_args[idx] = TRUE;
  return (1);
}

int			opt_str(oc,idx,addr)
t_opt_context		*oc;
int			idx;
char			**addr;
{
  if ((idx + 1) >= *(oc->argc))
    return (-ERR_NEEDMORE);
  (*addr) = oc->argv[idx + 1];
  oc->tr_args[idx] = TRUE;
  oc->tr_args[idx + 1] = TRUE;
  return (2);
}

int			opt_int(oc,idx,addr)
t_opt_context		*oc;
int			idx;
int			*addr;
{
  if ((idx + 1) >= *(oc->argc))
    return (-ERR_NEEDMORE);
  (*addr) = atoi(oc->argv[idx + 1]);
  oc->tr_args[idx] = TRUE;
  oc->tr_args[idx + 1] = TRUE;
  return (2);
}

int			opt_tr_args_matched(oc)
t_opt_context		*oc;
{
  int			matched;
  int			i;

  matched = 0;
  i = 0;
  while (i < *(oc->argc))
    {
      if (oc->tr_args[i] == TRUE)
	matched++;
      i++;
    }
  return (matched);
}

VOID_FUNC		opt_build_new_args(oc,matched)
t_opt_context		*oc;
int			matched;
{
  int			new_argc;
  int			i;
  int			j;    
  
  new_argc = *(oc->argc) - matched;
  i = 0;
  j = 0;
  while (i < *(oc->argc))
    {
      if (oc->tr_args[i] == FALSE)
	{
	  oc->argv[j] = oc->argv[i];
	  j++;
	}
      i++;
    }
  *(oc->argc) = new_argc;
}

t_status		opt_init_tr_args(oc)
t_opt_context		*oc;
{
  int			i;

  if (*(oc->argc) > oc->nb_tr_args)
    return (-ERR_TOOMANY);
  i = 0;
  while (i < *(oc->argc))
    {
      oc->tr_args[i] = FALSE;
      i++;
    }
  return (0);
}

t_status		opt_init_tr_opts(oc)
t_opt_context		*oc;
{
  int			i;

  if (oc->nb_opts > oc->nb_tr_opts)
    return (-ERR_TOOMANY);
  i = 0;
  while (i < oc->nb_opts)
    {
      oc->tr_opts[i] = 0; 
      i++;
    }
  return (0);
}

t_status		opt_get(oc)
t_opt_context		*oc;
{
  t_status		status;
  int			i;

  if ((status = opt_init_tr_args(oc)) < 0)
    return (status);
  if ((status = opt_init_tr_opts(oc)) < 0)
    return (status);
  i = 1;
next:
  while (i < *(oc->argc))
    {
      int		j;
      
      j = 0;
      while (j < oc->nb_opts)
	{
	  if (!strcmp(oc->argv[i],oc->opts[j].name))
	    {
	      char	*addr;
	      int	nmatch;

	      if (oc->tr_opts[j] == TRUE &&
		  !(oc->opts[j].flags & OPT_ALLOWMULTI))
		return (-ERR_EXIST);
	      addr = oc->base_addr + oc->opts[j].offset;
	      if ((nmatch = oc->opts[j].proc(oc,i,addr)) < 0)
		return (nmatch);
	      oc->tr_opts[j] = TRUE;
	      i += nmatch;
	      goto next;
	    }
	  j++;
	}
      i++;
    }
  {
    int			tr_args_matched;
    
    tr_args_matched = opt_tr_args_matched(oc);
    opt_build_new_args(oc,tr_args_matched);
    return (tr_args_matched);
  }
}

VOID_FUNC		opt_usage(f,opts,nb_opts,full_usage)
FILE			*f;
t_opt			*opts;
int			nb_opts;
t_boolean		full_usage;
{
  int			i;

  i = 0;
  while (i < nb_opts)
    {
      if (opts[i].param_comment != NULL)
	fprintf(f,"[%s %s]",opts[i].name,opts[i].param_comment);
      else
	fprintf(f,"[%s]",opts[i].name);
      if (full_usage)
	if (opts[i].comment != NULL)
	  fprintf(f," - %s\n",opts[i].comment);
	else
	  fprintf(f,"\n");
      i++;
    }
}

int			opt_check(opts,nb_opts)
t_opt			*opts;
int			nb_opts;
{
  int			i;

  i = 0;
  while (i < nb_opts)
    {
      int		j;

      j = 0;
      while (j < nb_opts)
	{
	  if (i != j && !strcmp(opts[i].name,opts[j].name))
	    return (-ERR_EXIST);
	  j++;
	}
      i++;
    }
  return (0);
}

