/*
 * This file is a part of the xnetsentry project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include <ctype.h>
#include "a.h"

int		ipow(x,n)
int		x;
int		n;
{
  int		result;

  result = 1;
  while (n--)
    {
      result *= x;
    }
  return (result);
}

int		ilog(x,y)
int		x;
int		y;
{
  int		result;

  if (y == 1)
    return (0);
  result = 1;
  while (y != x)
    {
      y /= x;
      result++;
    }
  return (result);
}

t_status	int_to_str(num,str,max_len)
int		num;
char		*str;
int		max_len;
{
  t_status	status;
  char		tmp[STR_BUFSIZ];
  char		*p;
  
  if (num < 0)
    {
      if ((status = str_cat_char(str,max_len,'-')) < 0)
	return (status);
      num = -num;
    }
  p = tmp + sizeof (tmp) - 1;
  tmp[sizeof (tmp) - 1] = '\0';
  do 
    {
      *--p = num % 10 + '0';
    } while ((num /= 10) != 0);
  while (*p)
    {
      if ((status = str_cat_char(str,max_len,*p++)) < 0)
	return (status);
    }
  return (0);
}

t_status	uint_to_str(num,str,max_len)
unsigned int	num;
char		*str;
int		max_len;
{
  t_status	status;
  char		tmp[STR_BUFSIZ];
  char		*p;

  p = tmp + sizeof (tmp) - 1;
  tmp[sizeof (tmp) - 1] = '\0';
  do 
    {
      *--p = num % 10 + '0';
    } while ((num /= 10) != 0);
  while (*p)
    {
      if ((status = str_cat_char(str,max_len,*p++)) < 0)
	return (status);
    }
  return (0);
}

t_boolean	atobooleanfalse(str)
char		*str;
{
  if (!strcasecmp(str,"true"))
    return (TRUE);
  return (FALSE);
}

t_boolean	atobooleantrue(str)
char		*str;
{
  if (!strcasecmp(str,"false"))
    return (FALSE);
  return (TRUE);
}

VOID_PTR	pool_alloc(pool,alloc_proc,size,comment,free_proc,status)
t_vec		*pool;
t_alloc_proc	alloc_proc;
size_t		size;
char		*comment;
t_free_proc	free_proc;
t_status	*status;
{
  VOID_PTR	ptr;

  if ((ptr = alloc_proc(size,comment,status)) == NULL)
    return (NULL);
  if (((*status) = vec_add(pool,ptr)) < 0)
    {
      free_proc(ptr,"ptr");
      return (NULL);
    }
}

char		*strdup_alloc(str,alloc_proc,comment,status)
char		*str;
t_alloc_proc	alloc_proc;
char		*comment;
t_status	*status;
{
  char		*nstr;
  int		len;

  len = strlen(str);
  if ((nstr = alloc_proc((len + 1) * sizeof (char),comment,status)) == NULL)
    return (NULL);
  strcpy(nstr,str);
  return (nstr);
}

t_assoc		*assoc_str_ptr_from_left(assoc,left)
t_assoc		*assoc;
char		*left;
{
  while (assoc->left)
    {
      if (!strcmp(assoc->left,left))
	return (assoc);
      assoc++;
    }
  return (NULL);
}

t_assoc		*assoc_str_int_from_right(assoc,right)
t_assoc		*assoc;
int		right;
{
  while (assoc->left)
    {
      if ((int)(assoc->right) == right)
	return (assoc);
      assoc++;
    }
  return (NULL);
}

t_boolean		uint_match(str)
char			*str;
{
  if (!(*str))
    return (FALSE);
  while (*str)
    {
      if (!isdigit(*str))
        return (FALSE);
      str++;
    }
  return (TRUE);
}

char		*str_skip(str,chars)
char		*str;
char		*chars;
{
  while (*str)
    {
      if (!index(chars,*str))
        return (str);
      str++;
    }
  return (NULL);
}

char		*str_find(str,chars)
char		*str;
char		*chars;
{
  while (*str)
    {
      if (index(chars,*str))
        return (str);
      str++;
    }
  return (NULL);
}

t_dict			*env_cache_dict = NULL;

/* NOT REENTRANT */
char			*env_cache(var,status)
char			*var;
t_status		*status;
{
  char			*value;
  t_hash_elt		*he;

  if (!env_cache_dict)
    {
      if ((env_cache_dict = DICT_NEW(status)) == NULL)
	return (NULL);
    }
  if (he = dict_get(env_cache_dict,var))
    return (he->value);
  if ((value = getenv(var)) == NULL)
    {
      *status = -ERR_NOSUCHVAR;
      return (NULL);
    }
  if (((*status) = dict_str_override(env_cache_dict,var,value)) < 0)
    return (NULL);
  return (env_cache(var,status));
}

VOID_FUNC		env_cache_delete(VOID_DECL)
{
  if (env_cache_dict)
    dict_str_delete(env_cache_dict);
}

char			*bindex(buf,len,c)
char			*buf;
int			len;
int			c;
{
  int			i;

  i = 0;
  while (i < len)
    {
      if (buf[i] == c)
	return (buf + i);
      i++;
    }
  return (NULL);
}

int			indexcount(str,c)
char			*str;
int			c;
{
  int			count;

  count = 0;
  while (*str)
    {
      if ((*str) == c)
	count++;
      str++;
    }
  return (count);
}

int		xdigit_value(xdigit)
int		xdigit;
{
  if (isdigit(xdigit))
    return (xdigit - '0');
  if (isupper(xdigit))
    return (10 + xdigit - 'A');
  return (10 + xdigit - 'a');
}

t_status	xdata_to_buf(xdata,buf,len,max_len)
char		*xdata;
char		*buf;
int		*len;
int		max_len;
{
  int		i;
  int		val;
  t_boolean	first;
  int		xdata_len;
  
  xdata_len = strlen(xdata);
  (*len) = 0;
  first = FALSE;
  val = 0;
  i = 0;
  while (i < xdata_len)
    {
      if (isxdigit(xdata[i]))
        {
          if (first)
            {
              val += xdigit_value(xdata[i]);
              if ((*len) < max_len)
                {
                  buf[(*len)++] = val;
                  val = 0;
                }
              else
		return (-ERR_BO);
	      first = FALSE;
            }
          else
            {
              val = 16 * xdigit_value(xdata[i]);
              first = TRUE;
            }
        }
      else
        if (!isspace(xdata[i]))
          return (-ERR_SYNTAX);
      i++;
    }
  return (0);
}

t_status	buf_to_xdata_str(buf,len,str,max_len)
char		*buf;
int		len;
char		*str;
int		max_len;
{
  t_status	status;
  int		i;

  i = 0;
  while (i < len)
    {
      if ((status = str_cat_fmt_va(str,
				   max_len,
				   "%02x",
				   (unsigned char)buf[i])) < 0)
	return (status);
      if ((status = str_cat_char(str,
				 max_len,
				 ' ')) < 0)
	return (status);
      i++;
    }
  return (0);
}

#ifdef DEBUG
t_boolean	more_verbose = FALSE;

VOID_FUNC	a_debug_init(VOID_DECL)
{
  char		*str;

  if (str = getenv("MORE_VERBOSE"))
    {
      more_verbose = atobooleanfalse(str);
    }
}
#endif
