/*
 * This file is a part of the xnetsentry project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include "a_matrix.h"

t_status	matrix_new_default(matrix,x,y,width,height,unused)
t_matrix	*matrix;
int		x;
int		y;
unsigned int	width;
unsigned int	height;
VOID_PTR	unused;
{
  int		i;
  int		j;

#ifdef NOTDEF
  fprintf(stderr,"exposure x=%d y=%d width=%d height=%d / %dx%d",
	  x,y,width,height,MATRIX_WIDTH(matrix),MATRIX_HEIGHT(matrix));
#endif
  j = y;
  while (j < height)
    {
      i = x;
      while (i < width)
	{
	  MATRIX_AT(matrix,i,j) = NULL;
	  i++;
	}
      j++;
    }
  return (0);
}

t_status	matrix_alloc(matrix)
t_matrix	*matrix;
{
  size_t	size;
  t_status	status;

  size = matrix->width * matrix->height * sizeof (VOID_PTR);
  if (size == 0)
    {
      matrix->elts = NULL;
      return (0);
    }
  if ((matrix->elts = matrix->alloc_proc(size,"matrix->elts",&status)) == NULL)
    return (status);
  if ((status = matrix->new_proc(matrix,
				 0,
				 0,
				 matrix->width,
				 matrix->height,
				 matrix->data)) < 0)
    {
      matrix->free_proc(matrix->elts,"matrix->elts");
      return (status);
    }
  return (0);
}

t_matrix		*matrix_new(width,
				    height,
				    dyn,
				    new_proc,
				    delete_proc,
				    data,
				    alloc_proc,
				    free_proc,
				    status)
unsigned int		width;
unsigned int		height;
t_boolean		dyn;
t_matrix_new_proc	new_proc;
t_matrix_delete_proc	delete_proc;
VOID_PTR		data;
t_alloc_proc		alloc_proc;
t_free_proc		free_proc;
t_status		*status;
{
  t_matrix		*matrix;
  
  if ((matrix = alloc_proc(sizeof (t_matrix),"matrix",status)) == NULL)
    return (NULL);
  matrix->dyn = dyn;
  matrix->width = width;
  matrix->height = height;
  matrix->alloc_proc = alloc_proc;
  matrix->free_proc = free_proc;
  matrix->new_proc = new_proc;
  matrix->delete_proc = delete_proc;
  matrix->data = data;
  if (((*status) = matrix_alloc(matrix)) < 0)
    {
      free_proc(matrix,"matrix");
      return (NULL);
    }
  return (matrix);
}

VOID_FUNC	matrix_destroy(matrix)
t_matrix	*matrix;
{
  if (matrix->elts)
    matrix->free_proc(matrix->elts,"matrix->elts");
  matrix->elts = NULL;
}

VOID_FUNC	matrix_delete(matrix)
t_matrix	*matrix;
{
  matrix_destroy(matrix);
  matrix->free_proc(matrix,"matrix");
}

t_status			matrix_resize(matrix,nwidth,nheight)
t_matrix			*matrix;
int				nwidth;
int				nheight;
{
  t_status			status;

  if (nwidth < 0)
    nwidth = matrix->width;
  if (nheight < 0)
    nheight = matrix->height;
  if (matrix->elts == NULL)
    {
      matrix->width = nwidth;
      matrix->height = nheight;
      return (0);
    }
  else
    {
      int			size;
      VOID_PTR			*p;
      int			old_width;
      int			old_height;

      size = nwidth * nheight * sizeof (VOID_PTR);
      if (size == 0)
	{
	  p = NULL;
	}
      else
	{
	  if ((p = matrix->alloc_proc(size,"p",&status)) == NULL)
	    return (status);
	}
      if (p)
	{
	  int		i;
	  int		j;

	  j = 0;
	  while (j < MIN(matrix->height,nheight))
	    {
	      i = 0;
	      while (i < MIN(matrix->width,nwidth))
		{
		  PTR_XY(p,nwidth,i,j) = MATRIX_AT(matrix,i,j);
		  i++;
		}
	      j++;
	    }
	}
      matrix->free_proc(matrix->elts,"matrix->elts");
      matrix->elts = p;
      old_width = matrix->width;
      old_height = matrix->height;
      matrix->width = nwidth;
      matrix->height = nheight;
      if (nwidth > old_width)
	{
	  if ((status = matrix->new_proc(matrix,
					 old_width,
					 0,
					 nwidth,
					 old_height,
					 matrix->data)) < 0)
	    return (status);
	}
      else
	if (nwidth < old_width)
	  {
	    if (matrix->delete_proc)
	      matrix->delete_proc(matrix,
				  nwidth,
				  0,
				  old_width,
				  old_height,
				  matrix->data);
	  }
      if (nheight > old_height)
	{
	  if ((status = matrix->new_proc(matrix,
					 0,
					 old_height,
					 old_width,
					 nheight,
					 matrix->data)) < 0)
	    return (status);
	}
      else
	if (nheight < old_height)
	  {
	    if (matrix->delete_proc)
	      matrix->delete_proc(matrix,
				  0,
				  nheight,
				  old_width,
				  old_height,
				  matrix->data);
	  }
      if (nwidth > old_width && nheight > old_height)
	{
	  if ((status = matrix->new_proc(matrix,
					 old_width,
					 old_height,
					 nwidth,
					 nheight,
					 matrix->data)) < 0)
	    return (status);
	}
      else
	if (nwidth < old_width && nheight < old_height)
	  {
	    if (matrix->delete_proc)
	      matrix->delete_proc(matrix,
				  nwidth,
				  nheight,
				  old_width,
				  old_height,
				  matrix->data);
	  }
      return (0);
    }
}

t_status		matrix_add(matrix,x,y,elt)
t_matrix		*matrix;
int			x;
int			y;
VOID_PTR		elt;
{
  int			nwidth;
  int			nheight;
  t_status		status;

#ifdef NOTDEF
  fprintf(stderr,"adding (%d,%d)=%d",x,y,elt);
#endif
  if (x < 0 || y < 0)
    return (-ERR_INVAL);
  nwidth = -1;
  nheight = -1;
  if (x >= matrix->width)
    {
      if (!(matrix->dyn))
	return (-ERR_NOTDYN);
      nwidth = x + 1;
    }
  if (y >= matrix->height)
    {
      if (!(matrix->dyn))
	return (-ERR_NOTDYN);
      nheight = y + 1;
    }
  if (nwidth > 0 || nheight > 0)
    {
      if ((status = matrix_resize(matrix,nwidth,nheight)) < 0)
	return (status);
    }
  if (matrix->elts == NULL)
    {
      if ((status = matrix_alloc(matrix)) < 0)
	return (status);
    }
  MATRIX_AT(matrix,x,y) = elt;
  return (0);
}

t_status		matrix_dup(src,dst)
t_matrix		*src;
t_matrix		**dst;
{
  size_t		size;
  t_status		status;
  
  if (((*dst) = src->alloc_proc(sizeof (t_matrix),"dst",&status)) == NULL)
    return (status);
  bcopy((char *)src,(char *)(*dst),sizeof (t_matrix));
  size = src->width * src->height * sizeof (VOID_PTR);
  if (size > 0)
    if (((*dst)->elts = src->alloc_proc(size,"dst->elts",&status)) == NULL)
      {
	src->free_proc(*dst,"*dst");
	return (status);
      }
  return (0);
}
