/*
 * This file is a part of the xnetsentry project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include "a.h"

t_vec			*hash_new(base,
				  list_base,
				  alloc_algorithm_proc,
				  alloc_proc,
				  free_proc,
				  status)
int			base;
int			list_base;
t_alloc_algorithm_proc	alloc_algorithm_proc;
t_alloc_proc		alloc_proc;
t_free_proc		free_proc;
t_status		*status;
{
  t_vec			*ht;
  int			i;
  
  if ((ht = vec_new(base,
		    TRUE,
		    alloc_algorithm_proc,
		    alloc_proc,
		    free_proc,
		    status)) == NULL)
    return (NULL);
  i = 0;
  while (i < base)
    {
      t_vec		*hl;

      if (((hl = vec_new(list_base,
			 FALSE,
			 alloc_algorithm_proc,
			 alloc_proc,
			 free_proc,
			 status)) == NULL) ||
	  (((*status) = vec_add(ht,hl)) < 0))
	{
	  int		j;

	  j = 0;
	  while (j < i)
	    {
	      vec_delete(VEC_AT(ht,j));
	      j++;
	    }
	  vec_delete(ht);
	  return (NULL);
	}
      i++;
    }
  return (ht);
}

VOID_FUNC		hash_destroy(ht,destroy_proc,data)
t_vec			*ht;
t_hash_destroy_proc	destroy_proc;
VOID_PTR		data;
{
  VEC_FOR(ht,t_vec *hl)
    {
      VEC_FOR(hl,t_hash_elt *he)
	{
	  destroy_proc(he,data);
	  ht->free_proc(he,"he");
	}
      VEC_ENDFOR;
      vec_destroy(hl);
    }
  VEC_ENDFOR;
}

VOID_FUNC		hash_delete(ht,destroy_proc,data)
t_vec			*ht;
t_hash_destroy_proc	destroy_proc;
VOID_PTR		data;
{
  VEC_FOR(ht,t_vec *hl)
    {
      VEC_FOR(hl,t_hash_elt *he)
	{
	  destroy_proc(he,data);
	  ht->free_proc(he,"he");
	}
      VEC_ENDFOR;
      vec_delete(hl);
    }
  VEC_ENDFOR;
  vec_delete(ht);
}

t_hash_elt		*hash_elt_new(ht,status)
t_vec			*ht;
t_status		*status;
{
  t_hash_elt		*he;

  if ((he = ht->alloc_proc(sizeof (t_hash_elt),"he",status)) == NULL)
    return (NULL);
  return (he);
}

t_status		hash_add(ht,hcode,key,value)
t_vec			*ht;
t_hash_code		hcode;
VOID_PTR		key;
VOID_PTR		value;
{
  t_vec			*hl;
  t_hash_elt		*he;
  t_status		status;

  hl = VEC_AT_MODULO(ht,hcode);
  if ((he = hash_elt_new(ht,&status)) == NULL)
    return (status);
  he->key = key;
  he->value = value;
  if ((status = vec_add(hl,he)) < 0)
    {
      ht->free_proc(he,"he");
      return (status);
    }
  return (0);
}

t_hash_elt		*hash_get(ht,hcode,cmp_proc,key)
t_vec			*ht;
t_hash_code		hcode;
t_hash_cmp_proc		cmp_proc;
VOID_PTR		key;
{
  t_vec			*hl;

  hl = VEC_AT_MODULO(ht,hcode);
  VEC_FOR(hl,t_hash_elt *he)
    {
      if (!cmp_proc(he->key,key))
	return (he);
    }
  VEC_ENDFOR;
  return (NULL);
}

t_status		hash_rm(ht,hcode,cmp_proc,key,destroy_proc,data)
t_vec			*ht;
t_hash_code		hcode;
t_hash_cmp_proc		cmp_proc;
VOID_PTR		key;
t_hash_destroy_proc	destroy_proc;
VOID_PTR		data;
{
  t_vec			*hl;

  hl = VEC_AT_MODULO(ht,hcode);
  VEC_FOR(hl,t_hash_elt *he)
    {
      if (!cmp_proc(he->key,key))
	{
	  destroy_proc(he,data);
	  VEC_RM_ELT(hl,he);
	  ht->free_proc(he,"he");
	  return (0);
	}
    }
  VEC_ENDFOR;
  return (-ERR_NOENT);
}

#ifdef DEBUG
VOID_FUNC		hash_show_repartition(ht)
t_vec			*ht;
{
  int			total;
  int			average;
  int			diff_total;
  int			diff_average;

  total = 0;
  VEC_FOR(ht,t_vec *hl)
    {
      total += VEC_COUNT(hl);
    }
  VEC_ENDFOR;
  average = total / VEC_COUNT(ht);
  fprintf(stderr,"average: %d\n",average);
  diff_total = 0;
  VEC_FOR(ht,t_vec *hl)
    {
      int		diff;
      
      diff = VEC_COUNT(hl) - average;
      if (more_verbose)
	fprintf(stderr,"slot %d: %d (%s%d)\n",
		VEC_IDX,
		VEC_COUNT(hl),
		(diff < 0)?"-":"+",
		ABS(diff));
      diff_total += ABS(diff);
    }
  VEC_ENDFOR;
  diff_average = diff_total / VEC_COUNT(ht);
  fprintf(stderr,"diff average: %d\n",diff_average);
}
#endif
