/*
 * This file is a part of the xnetsentry project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include "a.h"

char			*dict_str_value_dup(dict,value,status)
t_dict			*dict;
char			*value;
t_status		*status;
{
  char			*new_value;
  
  if ((new_value = dict->ht->alloc_proc(strlen(value) + 1,
					"new_value",status)) == NULL)
    return (NULL);
  strcpy(new_value,value);
  return (new_value);
}

t_status		dict_str_override(dict,key,value)
t_dict			*dict;
char			*key;
char			*value;
{
  t_hash_elt		*he;
  char			*nvalue;
  t_status		status;
  
  if ((nvalue = dict_str_value_dup(dict,value,&status)) == NULL)
    return (status);
  if (he = dict_get(dict,key))
    {
      dict->ht->free_proc(he->value,"he->value");
      he->value = nvalue;
      return (0);
    }
  else
    if ((status = dict_add(dict,key,nvalue)) < 0)
      {
	dict->ht->free_proc(nvalue,"nvalue");
	return (status);
      }
  return (0);
}

t_status		dict_str_add(dict,key,value)
t_dict			*dict;
char			*key;
char			*value;
{
  t_hash_elt		*he;
  t_status		status;
  
  if (he = dict_get(dict,key))
    return (-ERR_EXIST);
  else
    {
      char	*nvalue;
      
      if ((nvalue = dict_str_value_dup(dict,value,&status)) == NULL)
	return (status);
      if ((status = dict_add(dict,key,nvalue)) < 0)
	{
	  dict->ht->free_proc(nvalue,"nvalue");
	  return (status);
	}
    }
  return (0);
}

t_status		dict_str_rm(dict,key)
t_dict			*dict;
char			*key;
{
  t_hash_elt		*he;

  if ((he = dict_get(dict,key)) == NULL)
    return (-ERR_NOENT);
  dict->ht->free_proc(he->value,"he->value");
  return (dict_rm(dict,key));
}

VOID_FUNC		dict_str_destroy_elt(he,dict)
t_hash_elt		*he;
t_dict			*dict;
{
  dict->ht->free_proc(he->key,"he->key");
  dict->ht->free_proc(he->value,"he->value");
}

VOID_FUNC		dict_str_delete(dict)
t_dict			*dict;
{
  hash_delete(dict->ht,
	      (t_hash_destroy_proc)dict_str_destroy_elt,
	      dict);
  dict->ht->free_proc(dict,"dict");
}

char			*dict_str_get(dict,key)
t_dict			*dict;
char			*key;
{
  t_hash_elt		*he;

  if ((he = dict_get(dict,key)) == NULL)
    return (NULL);
  return (he->value);
}

int			dict_str_copy_override_cb(he,dst)
t_hash_elt		*he;
t_dict			*dst;
{
  return (dict_str_override(dst,he->key,he->value));
}

int			dict_str_copy_override(src,dst)
t_dict			*src;
t_dict			*dst;
{
  return (dict_walk(src,
		    (t_dict_walk_proc)dict_str_copy_override_cb,
		    dst));
}

VOID_PTR		dict_str_alloc_tmp(dict,size,status)
t_dict			*dict;
size_t			size;
t_status		*status;
{
  return (dict->ht->alloc_proc(size,"tmp",status));
}

t_status		dict_str_copy_override_suffix_cb(he,dsd)
t_hash_elt		*he;
t_dict_str_data		*dsd;
{
  t_status		status;
  char			*new_key;
  int			size;
  int			suffix_len;

  suffix_len = strlen(dsd->str);
  size = suffix_len + strlen(he->key) + 1;
  if ((new_key = dict_str_alloc_tmp(dsd->dict,size,&status)) == NULL)
    return (status);
  strcpy(new_key,dsd->str);
  strcpy(new_key + suffix_len,he->key);
  status = dict_str_override(dsd->dict,new_key,he->value);
  dsd->dict->ht->free_proc(new_key,"new_key");
  return (status);
}

t_status		dict_str_copy_override_suffix(src,dst,suffix)
t_dict			*src;
t_dict			*dst;
char			*suffix;
{
  t_dict_str_data	dsd;

  dsd.dict = dst;
  dsd.str = suffix;
  return (dict_walk(src,
		    (t_dict_walk_proc)dict_str_copy_override_suffix_cb,
		    &dsd));
}

t_status		dict_str_get_sub_prefix_cb(he,dsd)
t_hash_elt		*he;
t_dict_str_data		*dsd;
{
  t_status		status;
  char			*new_key;
  int			size;
  int			prefix_len;

  prefix_len = strlen(dsd->str);
  if (!strncmp(he->key,dsd->str,prefix_len))
    {
      size = strlen(he->key) - prefix_len + 1;
      if ((new_key = dict_str_alloc_tmp(dsd->dict,size,&status)) == NULL)
	return (status);
      strcpy(new_key,((char *)(he->key)) + prefix_len);
      status = dict_str_override(dsd->dict,new_key,he->value);
      dsd->dict->ht->free_proc(new_key,"new_key");
      return (status);
    }
  return (0);
}

t_status		dict_str_get_sub_prefix(src,dst,prefix)
t_dict			*src;
t_dict			*dst;
char			*prefix;
{
  t_dict_str_data	dsd;

  dsd.dict = dst;
  dsd.str = prefix;
  return (dict_walk(src,
		    (t_dict_walk_proc)dict_str_get_sub_prefix_cb,
		    &dsd));
}

t_status		dict_str_split(dict,str,sep)
t_dict			*dict;
char			*str;
int			sep;
{
  t_vec			*vec_str;
  t_status		status;

  if ((vec_str = vec_new(VEC_BASE,
			 FALSE,
			 dict->ht->alloc_algorithm_proc,
			 dict->ht->alloc_proc,
			 dict->ht->free_proc,
			 &status)) == NULL)
    return (status);
  if ((status = vec_str_split(vec_str,str,sep)) < 0)
    {
      vec_str_delete(vec_str);
      return (status);
    }
  VEC_FOR(vec_str,char *str)
    {
      char		*value;

      if ((value = index(str,'=')) == NULL)
	value = "";
      else
	*value++ = 0;
      if ((status = dict_str_override(dict,str,value)) < 0)
	{
	  vec_str_delete(vec_str);
	  return (status);
	}
    }
  VEC_ENDFOR;
  vec_str_delete(vec_str);
  return (0);
}

#ifdef DEBUG
t_status		dict_str_show_cb(he)
t_hash_elt		*he;
{
  fprintf(stderr,"`%s' `%s'\n",he->key,he->value);
  return (0);
}

VOID_FUNC		dict_str_show(dict)
t_dict			*dict;
{
  dict_walk(dict,(t_dict_walk_proc)dict_str_show_cb,NULL);
}
#endif

