/*
 * This file is a part of the xnetsentry project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include "a.h"

/* FROM DRAGON BOOK, P.436 */
t_hash_code		dict_hcode_dragon(buf,len)
char			*buf;
int			len;
{
  t_hash_code		hcode;
  t_hash_code		carry;

  hcode = 0;
  for ( ; len > 0; buf++, len--) 
    {
      hcode = (hcode << 4) + (*buf);
      if (carry = (hcode & 0xf0000000)) 
	{
	  hcode ^= (carry >> 24);
	  hcode ^= carry;
	}
    }
  return (hcode);
}

/* FROM A PUBLIC ROUTINE */
t_hash_code		dict_hcode_public(buf,len)
char			*buf;
int			len;
{
   t_hash_code		hcode;
   t_hash_code		value;
   
   hcode = 0;
   for (;len > 0;len--)
   {
      value = *buf++ & 0xFF;
      hcode += value * value;
   }
   return (hcode);
}

/* FROM GNU SMALLTALK-1.1.1 */
t_hash_code		dict_hcode_gst(buf,len)
char			*buf;
int			len;
{
  t_hash_code		result;

  result = 0L;
  for (; len > 0; buf++, len--)
    {
      result = (result << 1);
      result ^= *buf;
    }
  return (result);
}

t_dict			*dict_new(base,
				  list_base,
				  hcode_proc,
				  alloc_algorithm_proc,
				  alloc_proc,
				  free_proc,
				  status)
int			base;
int			list_base;
t_dict_hcode_proc	hcode_proc;
t_alloc_algorithm_proc	alloc_algorithm_proc;
t_alloc_proc		alloc_proc;
t_free_proc		free_proc;
t_status		*status;
{
  t_dict		*dict;
  
  if ((dict = alloc_proc(sizeof (t_dict),"dict",status)) == NULL)
    return (NULL);
  if ((dict->ht = hash_new(base,
			   list_base,
			   alloc_algorithm_proc,
			   alloc_proc,
			   free_proc,
			   status)) == NULL)
    {
      free_proc(dict,"dict");
      return (NULL);
    } 
  dict->hcode_proc = hcode_proc;
  return (dict);
}

VOID_FUNC		dict_destroy_elt(he,dict)
t_hash_elt		*he;
t_dict			*dict;
{
  dict->ht->free_proc(he->key,"he->key");
}

VOID_FUNC		dict_destroy(dict)
t_dict			*dict;
{
  hash_destroy(dict->ht,
	       (t_hash_destroy_proc)dict_destroy_elt,
	       dict);
}

VOID_FUNC		dict_delete(dict)
t_dict			*dict;
{
  t_free_proc		used_free_proc;

  used_free_proc = dict->ht->free_proc; 
  hash_delete(dict->ht,
	      (t_hash_destroy_proc)dict_destroy_elt,
	      dict);
  used_free_proc(dict,"dict");
}

t_hash_elt		*dict_get(dict,key)
t_dict			*dict;
char			*key;
{
  return (hash_get(dict->ht,
		   dict->hcode_proc(key,strlen(key)),
		   (t_hash_cmp_proc)strcmp,
		   key));
}

char			*dict_key_dup(dict,key,status)
t_dict			*dict;
char			*key;
t_status		*status;
{
  char			*new_key;
  
  if ((new_key = dict->ht->alloc_proc(strlen(key) + 1,"new_key",
				      status)) == NULL)
    return (NULL);
  strcpy(new_key,key);
  return (new_key);
}

t_status		dict_add(dict,key,value)
t_dict			*dict;
char			*key;
VOID_PTR		value;
{
  t_hash_elt		*he;

  if (he = dict_get(dict,key))
    return (-ERR_EXIST);
  else
    {
      char		*nkey;
      t_status		status;
      
      if ((nkey = dict_key_dup(dict,key,&status)) == NULL)
	return (status);
      if ((status = hash_add(dict->ht,
			     dict->hcode_proc(nkey,strlen(nkey)),
			     nkey,
			     value)) < 0)
	return (status);
    }
  return (0);
}

t_status		dict_override(dict,key,value)
t_dict			*dict;
char			*key;
VOID_PTR		value;
{
  t_hash_elt		*he;

  if (he = dict_get(dict,key))
    he->value = value;
  else
    return (dict_add(dict,key,value));
}
  
t_status		dict_rm(dict,key)
t_dict			*dict;
char			*key;
{
  return (hash_rm(dict->ht,
		  dict->hcode_proc(key,strlen(key)),
		  (t_hash_cmp_proc)strcmp,
		  key,
		  (t_hash_destroy_proc)dict_destroy_elt,
		  NULL));
}

t_boolean		dict_is_empty(dict)
t_dict			*dict;
{
  VEC_FOR(dict->ht,t_vec *hl)
    {
      VEC_FOR(hl,t_hash_elt *he)
	{
	  if (TRUE) /* avoid warning */
	    return (FALSE);
	}
      VEC_ENDFOR;
    }
  VEC_ENDFOR;
  return (TRUE);
}

int			dict_count(dict)
t_dict			*dict;
{
  int			count;

  count = 0;
  VEC_FOR(dict->ht,t_vec *hl)
    {
      VEC_FOR(hl,t_hash_elt *he)
	{
	  count++;
	}
      VEC_ENDFOR;
    }
  VEC_ENDFOR;
  return (count);
}

t_status		dict_walk(dict,proc,data)
t_dict			*dict;
t_dict_walk_proc	proc;
VOID_PTR		data;
{
  VEC_FOR(dict->ht,t_vec *hl)
    {
      VEC_FOR(hl,t_hash_elt *he)
	{
	  t_status	status;

	  if ((status = proc(he,data)) < 0)
	    return (status);
	}
      VEC_ENDFOR;
    }
  VEC_ENDFOR;
  return (0);
}	

t_status		dict_to_vec_hash_elt(dict,vec)
t_dict			*dict;
t_vec			*vec;
{
  VEC_FOR(dict->ht,t_vec *hl)
    {
      VEC_FOR(hl,t_hash_elt *he)
	{
	  t_status	status;

	  if ((status = vec_add(vec,he)) < 0)
	    return (status);
	}
      VEC_ENDFOR;
    }
  VEC_ENDFOR;
  return (0);
}

t_status		dict_walk_sorted_cmp(dict,walk_proc,cmp_proc,data)
t_dict			*dict;
t_dict_walk_proc	walk_proc;
t_vec_cmp_proc		cmp_proc;
VOID_PTR		data;
{
  int			status;
  t_vec			*vec;

  status = 0;
  if ((vec = vec_new(VEC_BASE,
		     FALSE,
		     dict->ht->alloc_algorithm_proc,
		     dict->ht->alloc_proc,
		     dict->ht->free_proc,
		     &status)) == NULL)
    return (status);
  if ((status = dict_to_vec_hash_elt(dict,vec)) < 0)
    goto bad;
  vec_sort(vec,cmp_proc);
  VEC_FOR(vec,t_hash_elt *sorted_he)
    {
      t_status		status;
      
      if ((status = walk_proc(sorted_he,data)) < 0)
	goto bad;
    }
  VEC_ENDFOR;
bad:
  vec_delete(vec);
  return (status);
}	

int			dict_walk_sorted_cmp_cb(p1,p2)
VOID_PTR		*p1;
VOID_PTR		*p2;
{
  t_hash_elt		*he1;
  t_hash_elt		*he2;

  he1 = (t_hash_elt *)(*p1);
  he2 = (t_hash_elt *)(*p2);
  return (strcmp(he1->key,he2->key));
}

t_status		dict_walk_sorted(dict,walk_proc,data)
t_dict			*dict;
t_dict_walk_proc	walk_proc;
VOID_PTR		data;
{
  return (dict_walk_sorted_cmp(dict,
			       walk_proc,
			       (t_vec_cmp_proc)dict_walk_sorted_cmp_cb,
			       data));
}

t_status		dict_max_len_cb(he,max_len)
t_hash_elt		*he;
int			*max_len;
{
  int			len;

  len = strlen(he->key);
  if (len > (*max_len))
    *max_len = len;
  return (0);
}

int			dict_max_len(dict,status)
t_dict			*dict;
t_status		*status;
{
  int			max_len;
  
  max_len = 0;
  if (((*status) = dict_walk(dict,
			     (t_dict_walk_proc)dict_max_len_cb,
			     &max_len)) < 0)
    return (-1);
  return (max_len);
}

#ifdef DEBUG
t_status		dict_show_cb(he,unused)
t_hash_elt		*he;
VOID_PTR		unused;
{
  fprintf(stderr,"key=`%s' value=0x%x\n",he->key,he->value);
  return (0);
}

VOID_FUNC		dict_show(dict)
t_dict			*dict;
{
  dict_walk(dict,(t_dict_walk_proc)dict_show_cb,NULL);
}

VOID_FUNC		dict_show_sorted(dict)
t_dict			*dict;
{
  dict_walk_sorted(dict,(t_dict_walk_proc)dict_show_cb,NULL);
}
#endif
