# Local addition to autoconf macros.
# Copyright (C) 1998
# Marting Gall

# Local additions to Autoconf macros.
# Copyright (C) 1992, 1994 Free Software Foundation, Inc.
# Francois Pinard <pinard@iro.umontreal.ca>, 1992.

# @defmac AC_PROG_CC_STDC
# @maindex PROG_CC_STDC
# @ovindex CC
# If the C compiler in not in ANSI C mode by default, try to add an option
# to output variable @code{CC} to make it so.  This macro tries various
# options that select ANSI C on some system or another.  It considers the
# compiler to be in ANSI C mode if it defines @code{__STDC__} to 1 and
# handles function prototypes correctly.
# 
# If you use this macro, you should check after calling it whether the C
# compiler has been set to accept ANSI C; if not, the shell variable
# @code{ac_cv_prog_cc_stdc} is set to @samp{no}.  If you wrote your source
# code in ANSI C, you can make an un-ANSIfied copy of it by using the
# program @code{ansi2knr}, which comes with Ghostscript.
# @end defmac

define(fp_PROG_CC_STDC,
[AC_MSG_CHECKING(for ${CC-cc} option to accept ANSI C)
AC_CACHE_VAL(ac_cv_prog_cc_stdc,
[ac_cv_prog_cc_stdc=no
ac_save_CFLAGS="$CFLAGS"
# Don't try gcc -ansi; that turns off useful extensions and
# breaks some systems' header files.
# AIX			-qlanglvl=ansi
# Ultrix and OSF/1	-std1
# HP-UX			-Aa -D_HPUX_SOURCE
# SVR4			-Xc
for ac_arg in "" -qlanglvl=ansi -std1 "-Aa -D_HPUX_SOURCE" -Xc
do
  CFLAGS="$ac_save_CFLAGS $ac_arg"
  AC_TRY_COMPILE(
[#if !defined(__STDC__) || __STDC__ != 1
choke me
#endif	
], [int test (int i, double x);
struct s1 {int (*f) (int a);};
struct s2 {int (*f) (double a);};],
[ac_cv_prog_cc_stdc="$ac_arg"; break])
done
CFLAGS="$ac_save_CFLAGS"
])
AC_MSG_RESULT($ac_cv_prog_cc_stdc)
case "x$ac_cv_prog_cc_stdc" in
  x|xno) ;;
  *) CC="$CC $ac_cv_prog_cc_stdc" ;;
esac
])

# Check for function prototypes.

AC_DEFUN(fp_C_PROTOTYPES,
[AC_REQUIRE([fp_PROG_CC_STDC])
AC_MSG_CHECKING([for function prototypes])
if test "$ac_cv_prog_cc_stdc" != no; then
  AC_MSG_RESULT(yes)
  AC_DEFINE(HAVE_PROTOTYPES)
  U= ANSI2KNR=
else
  AC_MSG_RESULT(no)
  U=_ ANSI2KNR=ansi2knr
fi
AC_SUBST(U)dnl
AC_SUBST(ANSI2KNR)dnl
])

# Check for void func

AC_DEFUN(mg_C_VOID_FUNC,
[AC_MSG_CHECKING([for void func])
AC_CACHE_VAL(ac_cv_c_void_func,
[AC_TRY_COMPILE(
[],
[void test();],
ac_cv_c_void_func=yes,ac_cv_c_void_func=no)
])
AC_MSG_RESULT($ac_cv_c_void_func)
if test "$ac_cv_c_void_func" != no
then
	AC_DEFINE(HAVE_VOID_FUNC)
fi
])

# Check for void ptr

AC_DEFUN(mg_C_VOID_PTR,
[AC_MSG_CHECKING([for void ptr])
AC_CACHE_VAL(ac_cv_c_void_ptr,
[AC_TRY_COMPILE(
[],
[void *test;],
ac_cv_c_void_ptr=yes,ac_cv_c_void_ptr=no)
])
AC_MSG_RESULT($ac_cv_c_void_ptr)
if test "$ac_cv_c_void_ptr" != no
then
	AC_DEFINE(HAVE_VOID_PTR)
fi
])

# Check for void decl

AC_DEFUN(mg_C_VOID_DECL,
[AC_MSG_CHECKING([for void decl])
AC_CACHE_VAL(ac_cv_c_void_decl,
[AC_TRY_COMPILE(
[],
[int test(void);],
ac_cv_c_void_decl=yes,ac_cv_c_void_decl=no)
])
AC_MSG_RESULT($ac_cv_c_void_decl)
if test "$ac_cv_c_void_decl" != no
then
	AC_DEFINE(HAVE_VOID_DECL)
fi
])

# Check for ansi cpp

AC_DEFUN(mg_C_ANSI_CPP,
[AC_MSG_CHECKING([for ansi cpp])
AC_CACHE_VAL(ac_cv_c_ansi_cpp,
[AC_TRY_RUN(
[#define QUOTE(expr) #expr
int main()
{
exit(strcmp("a",QUOTE(a)));
}],ac_cv_c_ansi_cpp=yes,ac_cv_c_ansi_cpp=no,:)
])
AC_MSG_RESULT($ac_cv_c_ansi_cpp)
if test "$ac_cv_c_ansi_cpp" != no
then
	AC_DEFINE(HAVE_ANSI_CPP)
fi
])

# Check for bitfields

AC_DEFUN(mg_C_BITFIELDS,
[AC_MSG_CHECKING([for bitfields])
AC_CACHE_VAL(ac_cv_c_bitfields,
[AC_TRY_COMPILE(
[],
[struct test {unsigned char a:4;unsigned char b:4};],
ac_cv_c_bitfields=yes,ac_cv_c_bitfields=no)
])
AC_MSG_RESULT($ac_cv_c_bitfields)
if test "$ac_cv_c_bitfields" != no
then
	AC_DEFINE(HAVE_BITFIELDS)
fi
])

# Check for debug

AC_DEFUN(mg_WITH_DEBUG,
[AC_MSG_CHECKING(if debug is wanted)
AC_ARG_WITH(debug,
[  --with-debug            compile with DEBUG],
[if test "$withval" = yes; then
  AC_MSG_RESULT(yes)
  AC_DEFINE(DEBUG)
else
  AC_MSG_RESULT(no)
fi], [AC_MSG_RESULT(no)])])

# Check for debug malloc

AC_DEFUN(mg_WITH_DEBUG_MALLOC,
[AC_MSG_CHECKING(if debug malloc is wanted)
AC_ARG_WITH(debug_malloc,
[  --with-debug-malloc     compile with DEBUG_MALLOC],
[if test "$withval" = yes; then
  AC_MSG_RESULT(yes)
  AC_DEFINE(DEBUG_MALLOC)
else
  AC_MSG_RESULT(no)
fi], [AC_MSG_RESULT(no)])])

# Check for extra include

AC_DEFUN(mg_WITH_EXTRA_INCLUDE,
[AC_MSG_CHECKING(for extra include)
AC_ARG_WITH(extra_include,
[  --with-extra-include=DIR
                          add an extra include dir],
[if test ! -z "$withval"; then
  AC_MSG_RESULT($withval)
  INCLUDES="$INCLUDES -I$withval"
else
  AC_MSG_RESULT(none)
fi], [AC_MSG_RESULT(none)])])

# Check for extra libpath

AC_DEFUN(mg_WITH_EXTRA_LIBPATH,
[AC_MSG_CHECKING(for extra libpath)
AC_ARG_WITH(extra_libpath,
[  --with-extra-libpath=DIR
                          add an extra libpath],
[if test ! -z "$withval"; then
  AC_MSG_RESULT($withval)
  LDFLAGS="$LDFLAGS -L$withval"
else
  AC_MSG_RESULT(none)
fi], [AC_MSG_RESULT(none)])])

# Check if --with-pcap was given.

AC_DEFUN(mg_WITH_PCAP,
[AC_MSG_CHECKING(if pcap is wanted)
AC_ARG_WITH(pcap,
[  --with-pcap		use libpcap],
[if test "$withval" = yes; then
  AC_MSG_RESULT(yes)
  AC_DEFINE(WITH_PCAP)
  LIBS="$LIBS -lpcap"
else
  AC_MSG_RESULT(no)
fi], [AC_MSG_RESULT(no)])])

AC_DEFUN(mg_WITH_PCAP_INCLUDE,
[AC_MSG_CHECKING(pcap include location)
AC_ARG_WITH(pcap_include,
[  --with-pcap-include		libpcap include location])
if test ! -z "$with_pcap_include" ; then
 	AC_MSG_RESULT($with_pcap_include)
	INCLUDES="$INCLUDES -I$with_pcap_include"
else
	AC_MSG_RESULT(none)
fi
],)])

AC_DEFUN(mg_WITH_PCAP_LIBRARY,
[AC_MSG_CHECKING(pcap library location)
AC_ARG_WITH(pcap_library,
[  --with-pcap-library		libpcap library location])
if test ! -z "$with_pcap_library" ; then
 	AC_MSG_RESULT($with_pcap_library)
	LDFLAGS="$LDFLAGS -L$with_pcap_library"
else
	AC_MSG_RESULT(none)
fi
],)])

# Check for data_integrity

AC_DEFUN(mg_WITH_DATA_INTEGRITY,
[AC_MSG_CHECKING(if data_integrity is wanted)
AC_ARG_WITH(data_integrity,
[  --with-data-integrity            compile with DATA_INTEGRITY],
[if test "$withval" = yes; then
  AC_MSG_RESULT(yes)
  AC_DEFINE(WITH_DATA_INTEGRITY)
else
  AC_MSG_RESULT(no)
fi], [AC_MSG_RESULT(no)])])

# Check for data_integrity

AC_DEFUN(mg_WITH_MG_KLUDGE,
[AC_MSG_CHECKING(if mg_kludge is wanted)
AC_ARG_WITH(mg_kludge,
[  --with-mg-kludge            compile with MG_KLUDGE],
[if test "$withval" = yes; then
  AC_MSG_RESULT(yes)
  AC_DEFINE(WITH_MG_KLUDGE)
else
  AC_MSG_RESULT(no)
fi], [AC_MSG_RESULT(no)])])
