/* xexec daemon, (c) 1997 Adam Ierymenko  Public domain software */
/* Version 1.00 */

#include <stdio.h>
#include <stdarg.h>
#include <unistd.h>
#include <stdlib.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <arpa/inet.h>
#include <fcntl.h>
#include <syslog.h>
#include <string.h>

/* Define this for silent startup */
#undef QUIET_START

/* Global variables */
struct allowedips {
	struct in_addr ip;
	struct allowedips *next;
};
struct connections {
	int p;
	char readbuf[256];
	int readbufptr;
	struct connections *next,*last;
};
struct connections *connects = (struct connections *)0;
struct allowedips *allowedaddrs = (struct allowedips *)0;
int listenplug;
fd_set readfds,nullfds;

/* Accepts a connection from a host-- disallows it if not from a correct
 * IP or if not from priviledged port.  Returns nonzero if success. */
int accept_connect(void)
{
	struct sockaddr_in addr;
	int addrlen = sizeof(addr);
	register struct allowedips *aa = allowedaddrs;
	int p;
	
	if ((p = accept(listenplug,(struct sockaddr *)&addr,&addrlen)) > 0) {
		while(aa) {
			if (addr.sin_addr.s_addr == aa->ip.s_addr)
				goto good_addr;
			aa = aa->next;
		}
		syslog(LOG_ERR,"refused request from %s: not from authorized IP",inet_ntoa(addr.sin_addr));
		close(p);
		return 0;
good_addr:
		if (ntohs(addr.sin_port) >= 1024) {
			syslog(LOG_ERR,"refused request from %s: not from priveledged port",inet_ntoa(addr.sin_addr));
			close(p);
			return 0;
		}
		return p;
	}
	return 0;
}

/* Parses an execute message
 * The format of this message is:
 * <uid> <gid> <directory to change to (. for no change)> <command> <args...>
 *      ^ Seperator is 0xff (ascii 255)
 */
void parse_msg(msg,p)
	char *msg;
	int p;
{
	char *parms[256];
	int i = 1;
	
	if (!(parms[0] = strtok(msg,"\377")))
		return;
	while ((parms[i++] = strtok(NULL,"\377"))) {
		if (i >= 255)
			break;
	}
	parms[i] = (char *)0;
	
	if (i < 5)
		return;

	if (!fork()) {
		close(STDOUT_FILENO);
		close(STDERR_FILENO);
		close(STDIN_FILENO);
		close(p);
		if (setgid(atoi(parms[1])))
			exit(0);
		if (setuid(atoi(parms[0])))
			exit(0);
		chdir(parms[2]);
		execv(parms[3],&(parms[3]));
		exit(0);
	}
}

/* Reads from a connect */
void read_connect(conn)
	struct connections *conn;
{
	int n;
	static char readbuf[256];
	register int i;
	
	if ((n = recv(conn->p,&readbuf,sizeof(readbuf),0)) > 0) {
		for(i=0;i<n;i++) {
			if (!(conn->readbuf[conn->readbufptr++] = readbuf[i])) {
				parse_msg(conn->readbuf,conn->p);
				goto drop_connection;
			}
		}
	} else {
drop_connection:
		close(conn->p);
		FD_CLR(conn->p,&readfds);
		if ((conn->next)&&(conn->last)) {
			conn->next->last = conn->last;
			conn->last->next = conn->next;
		} else if (conn->last) {
			conn->last->next = (struct connections *)0;
		} else if (conn->next) {
			conn->next->last = (struct connections *)0;
			connects = conn->next;
		} else connects = (struct connections *)0;
		free(conn);
	}
}

/* Main select loop */
void do_select(void)
{
	fd_set rfds;
	int newfd;
	register struct connections *c,*c2;
	struct timeval t;
	
start_select:
	t.tv_sec = 2;
	t.tv_usec = 0;
	waitpid(-1,NULL,WNOHANG);
	memcpy(&rfds,&readfds,sizeof(rfds));
	if (select(getdtablesize(),&rfds,&nullfds,&nullfds,&t) <= 0)
		goto start_select;
	
	if (FD_ISSET(listenplug,&rfds)) {
		if ((newfd = accept_connect()) > 0) {
			fcntl(newfd,F_SETFL,O_NONBLOCK);
			FD_SET(newfd,&readfds);
			c = malloc(sizeof(struct connections));
			c->p = newfd;
			c->last = (struct connections *)0;
			c->readbufptr = 0;
			if ((c->next = connects))
				connects->last = c;
			connects = c;
		}
	}
	
	c = connects;
	while(c) {
		c2 = c->next;
		if (FD_ISSET(c->p,&rfds))
			read_connect(c);
		c = c2;
	}
	goto start_select;
}

void main(int argc,char **argv)
{
	struct allowedips *aa;
	int i,port;
	struct sockaddr_in addr;
	
	FD_ZERO(&readfds);
	FD_ZERO(&nullfds);

	if (argc <= 2) {
		printf("Usage: %s <port> <space-seperated list of authorized IP addresses>\n",argv[0]);
		return;
	}
	if (getuid()) {
		printf("Must be run as root\n");
		return;
	}
	port = atoi(argv[1]);
	
	for(i=2;i<argc;i++) {
		aa = malloc(sizeof(struct allowedips));
		aa->ip.s_addr = inet_addr(argv[i]);
		aa->next = allowedaddrs;
		allowedaddrs = aa;
	}
	
#ifndef QUIET_START
	printf("xexecd starting...\nauthorized addresses:");
	aa = allowedaddrs;
	while(aa) {
		printf(" %s",inet_ntoa(aa->ip));
		aa = aa->next;
	}
	printf("\n"); fflush(stdout);
#endif
	
	if (fork())
		return;
	
	openlog("xexecd",LOG_PID,LOG_DAEMON);

	for(i=0;i<argc;i++)
		bzero(argv[i],strlen(argv[i]));
	sprintf(argv[0],"xexecd [%d]",port);

	if ((listenplug = socket(AF_INET,SOCK_STREAM,0)) <= 0) {
		printf("Couldn't create socket\n");
		return;
	}
	addr.sin_family = AF_INET;
	addr.sin_addr.s_addr = INADDR_ANY;
	addr.sin_port = htons(port);
	if (bind(listenplug,(struct sockaddr *)&addr,sizeof(addr))) {
		printf("Couldn't bind to port\n");
		return;
	}
	if (listen(listenplug,4))
		return;
	fcntl(listenplug,F_SETFL,O_NONBLOCK);
	FD_SET(listenplug,&readfds);
	
	do_select();
}
