/* xexec client, (c) 1997 Adam Ierymenko  Public domain software */
/* Version 1.00 */

#include <stdio.h>
#include <stdarg.h>
#include <unistd.h>
#include <stdlib.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <arpa/inet.h>
#include <string.h>

/* Sockets below this are priviledged */
#define PROTECTED_SOCK 1024

/*
 * Usage: xexec ipaddr port cwd command [args...]
 */
void main(int argc,char **argv)
{
	struct sockaddr_in addr;
	int plug,i,n;
	char buf[256];
	int myuid,mygid;
	
	if (argc < 5) {
		printf("Usage: %s <ip> <port> <remote cwd (. if none)> <command> [<args...>]\n",argv[0]);
		return;
	}
	myuid = getuid();
	mygid = getgid();
	if (setuid(0)) {
		printf("Must be setuid root\n");
		return;
	}
	srand(getpid());
	
	if ((plug = socket(AF_INET,SOCK_STREAM,0)) <= 0) {
		printf("Could not create socket\n");
		return;
	}
	do {
		addr.sin_family = AF_INET;
		addr.sin_port = htons((rand() % (1024-200)) + 199);
		addr.sin_addr.s_addr = INADDR_ANY;
	} while (bind(plug,(struct sockaddr *)&addr,sizeof(addr)));
	addr.sin_port = htons(atoi(argv[2]));
	addr.sin_addr.s_addr = inet_addr(argv[1]);
	n = sprintf(buf,"%d\377%d\377%s\377%s",myuid,mygid,argv[3],argv[4]);
	for(i=5;i<argc;i++)
		n += sprintf(&(buf[n]),"\377%s",argv[i]);
	if (connect(plug,(struct sockaddr *)&addr,sizeof(addr))) {
		printf("Could not connect to %s(%d): %s\n",inet_ntoa(addr.sin_addr),ntohs(addr.sin_port),strerror(errno));
		return;
	}
	if (send(plug,&buf,n+1,0) != n+1) {
		printf("Write error: %s\n",strerror(errno));
		return;
	}
	close(plug);
}
