/*******************************************************************************
* plh_math.h								       *
********************************************************************************
* Routines having to do with mathematics and mathematical operations.	       *
*******************************************************************************/

/*FLAGS************************************************************************/

/*CONSTANTS********************************************************************/

/*MACROS***********************************************************************/

			/*******************************************************
			* Macros to substitute for the mathematical operators  *
			* to keep a 'function' appearance to the program       *
			* without a sacrifice in overhead.		       *
			********************************************************
			* left		left operand for operation	       *
			* right 	right operand for operation	       *
			*******************************************************/
#define ADD(left, right)	( (left) + (right) )
#define SUBTRACT(left, right)	( (left) - (right) )
#define MULTIPLY(left, right)	( (left) * (right) )
#define DIVIDE(left, right)	( (left) / (right) )
#define MODULA(left, right)	( (left) % (right) )
 
			/*******************************************************
			* Macro to specify a prime number by showing that its  *
			* smallest factor equal to itself.		       *
			********************************************************
			* i		Integer to test for prime	       *
			*******************************************************/
#define IS_PRIME(i)	( (i) == GetAFactor(i) )

/*TYPE*DEFINITIONS*************************************************************/

/*EXTERNAL*GLOBAL*VARIABLES****************************************************/

/*EXTERNAL*ROUTINES************************************************************/

			/*******************************************************
			* Routine to accept a positive value and return the    *
			* smallest factor of it found. If a negative number is *
			* passed, the routine uses its absolute value.         *
			********************************************************
			* value		Integer value to test for a factor     *
			*******************************************************/
unsigned long GetAFactor(unsigned long value);

			/*******************************************************
			* Routine to print all factors of a passed number.     *
			* Lists the factors in a row. The routine does not     *
			* print a newline at the end of the list.	       *
			********************************************************
			* value		Integer value to factor		       *
			*******************************************************/
void ShowAllFactors(unsigned long value);
