/*******************************************************************************
* template.h								       *
********************************************************************************
* HEADER:								       *
* This is a template header file for standard generation.    		       *
* Describe the purpose of the header existence here.			       *
* There should be one header file associated with each library.		       *
* Library routines should be in separate *.c files for easier replacement.     *
* This file should include no other files than those needed for types & macros.*
*******************************************************************************/

#include <plh_memory.h>

/*FLAGS************************************************************************/

/*CONSTANTS********************************************************************/

/*MACROS***********************************************************************/

			/*******************************************************
			* Macros to expand the bit operations for those that   *
			* keep mixing up the operatos &, ^, and |. Also keeps  *
			* program in a fully 'function' format without adding  *
			* overhead. (for those used to assembly)	       *
			********************************************************
			* left		left operand for operation	       *
			* right		right operand for operation	       *
			*******************************************************/
#define AND(left, right)		( (left) & (right) )
#define XOR(left, right)		( (left) ^ (right) )
#define EOR(left, right)		XOR(left, right)
#define OR(left, right)			( (left) | (right) )

/*TYPE*DEFINITIONS*************************************************************/

			/* Structure for separating an 8-bit data structure   */
			/* into all common bit combinations.		      */
typedef
 union
  {
   struct
    {
      unsigned byte0:8;
    } bytes;  

   struct
    {
      unsigned nib0:4;
      unsigned nib1:4;
    } nibbles;

   struct
    {
      unsigned bit0:1;
      unsigned bit1:1;
      unsigned bit2:1;
      unsigned bit3:1;
      unsigned bit4:1;
      unsigned bit5:1;
      unsigned bit6:1;
      unsigned bit7:1;
    } bits;
  }
bit8;

			/* Structure for separating an 16-bit data structure  */
			/* into all common bit combinations.		      */
typedef
 union
  {
   struct
    {
      unsigned word0:16;
    } words;

   struct
    {
      unsigned byte0:8;
      unsigned byte1:8;
    } bytes;  

   struct
    {
      unsigned nib0:4;
      unsigned nib1:4;
      unsigned nib2:4;
      unsigned nib3:4;
    } nibbles;

   struct
    {
      unsigned bit0:1;
      unsigned bit1:1;
      unsigned bit2:1;
      unsigned bit3:1;
      unsigned bit4:1;
      unsigned bit5:1;
      unsigned bit6:1;
      unsigned bit7:1;
      unsigned bit8:1;
      unsigned bit9:1;
      unsigned bit10:1;
      unsigned bit11:1;
      unsigned bit12:1;
      unsigned bit13:1;
      unsigned bit14:1;
      unsigned bit15:1;
    } bits;
  }
bit16;

			/* Structure for separating an 32-bit data structure  */
			/* into all common bit combinations.		      */
typedef
 union
  {
   struct
    {
      unsigned dword0:32;
    } dwords;
    
   struct
    {
      unsigned word0:16;
      unsigned word1:16;
    } words;

   struct
    {
      unsigned byte0:8;
      unsigned byte1:8;
      unsigned byte2:8;
      unsigned byte3:8;
    } bytes;  

   struct
    {
      unsigned nib0:4;
      unsigned nib1:4;
      unsigned nib2:4;
      unsigned nib3:4;
      unsigned nib4:4;
      unsigned nib5:4;
      unsigned nib6:4;
      unsigned nib7:4;
    } nibbles;

   struct
    {
      unsigned bit0:1;
      unsigned bit1:1;
      unsigned bit2:1;
      unsigned bit3:1;
      unsigned bit4:1;
      unsigned bit5:1;
      unsigned bit6:1;
      unsigned bit7:1;
      unsigned bit8:1;
      unsigned bit9:1;
      unsigned bit10:1;
      unsigned bit11:1;
      unsigned bit12:1;
      unsigned bit13:1;
      unsigned bit14:1;
      unsigned bit15:1;
      unsigned bit16:1;
      unsigned bit17:1;
      unsigned bit18:1;
      unsigned bit19:1;
      unsigned bit20:1;
      unsigned bit21:1;
      unsigned bit22:1;
      unsigned bit23:1;
      unsigned bit24:1;
      unsigned bit25:1;
      unsigned bit26:1;
      unsigned bit27:1;
      unsigned bit28:1;
      unsigned bit29:1;
      unsigned bit30:1;
      unsigned bit31:1;
    } bits;
  }
bit32;

/*EXTERNAL*GLOBAL*VARIABLES****************************************************/

/*EXTERNAL*ROUTINES************************************************************/

			/*******************************************************
			* Routine to take the passed 8-bit data structure      *
			* pointer and reflect the bits about the access        *
			* between the 3 & 4 bits (starting at 0). This creates *
			* a mirror image (like writing the bits, then reading  *
			* them off their reflection in a mirror. Returns       *
			* pointer to mirrored version of the 8-bit structure.  *
			*	Ex.	10010110	->	01101001       *
			********************************************************
			* original	pointer to 8-bit structure to mirror   *
			*******************************************************/
char *BitMirror8(char *original);

			/*******************************************************
			* Routine to display data in the form of a string of   *
			* bits. Allows listing of bit ranges from 1 to 32. The *
			* routine does NOT print a carriage return after the   *
			* binary data. A value outside of the range 1-32 is    *
			* handled by using its value modula 33.		       *
			********************************************************
			* value		value which you wish to show	       *
			* num		number of bits to display (LSB first)  *
			*******************************************************/
void ShowBits(unsigned long value, char num);			
