/*  sas - sane authentication scheme.
    Copyright (C) 2001 Quentin Sharpe <qsharpe@btinternet.com>.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
*/

#include <sys/types.h>
#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include "confread.h"
#include "global.h"

void usage(void);
void version(void);

/* command line options */
char config_file[MAX_FILENAME_LEN];	// "-f <conf_file_path>" an alternative config file to /etc/cctv.conf

char temp_buffer[2];

/* read in cctv.conf and perform operations specified */
int main(int argc, char *argv[])
{
	uid_t uid;
	int i;


	uid=getuid();

	if(uid != 0) {
		fprintf(stderr,"%s: must be run as root!\n",__progname);
		exit(1);
	}

	sprintf(config_file,"%s",CONF_FILE_PATH);
	output_level=1;
	USERNAME_ONLY=0;
	SYS_CALL_CHECK=0;
	
	if(argc == 1) {
	;
	}
	else {
		for(i=1; i<argc; i++) {
			if(argv[i][0] == '-' && argv[i][1] && argv[i][1] == '-') {
					if(strcmp(argv[i],"--help")==0) {
						usage();
					}
					else if(strcmp(argv[i],"--version")==0) {
						version();
					}
					else if(strcmp(argv[i],"--username_only")==0) {
						USERNAME_ONLY=1;
					}
					else if(strcmp(argv[i],"--verbose")==0) {
						VERBOSE_OUTPUT=1;
					}
					else if(strcmp(argv[i],"--system_calls")==0) {
						SYS_CALL_CHECK=1;
					}
					else if(strcmp(argv[i],"--EMERG")==0) {
						output_level=3;
					}
					else if(strcmp(argv[i],"--WARN")==0) {
						output_level=2;
					}
					else if(strcmp(argv[i],"--INFO")==0) {
						output_level=1;
					}
					else if(strcmp(argv[i],"--DEBUG")==0) {
						output_level=0;
					}
					else if(strcmp(argv[i],"--help")==0) {
						usage();
					}
					else {
						fprintf(stderr,"%s: %s: %s\n",__progname,"invalid option",argv[i]);
						usage();
					}
			}
			else if(argv[i][0] == '-' && argv[i][1]) {
				switch(argv[i][1]) {
					case 'v':
						VERBOSE_OUTPUT=1;
						break;
					case 'V':
						version();
					case 'o':
					case 'O':
						if(argv[i][2]) {
							if(isdigit(argv[i][2])) {
								temp_buffer[0]=argv[i][2];
								temp_buffer[1]='\0';
								output_level=3-(atoi(temp_buffer));
								if(output_level < 0 || output_level > 3) {
									fprintf(stderr,"%s: %s\n",__progname,"invalid output value");
									usage();
								}
							}
							else usage();
						}
						else if(argv[i+1][0] && isdigit(argv[i+1][0])) {
							temp_buffer[0]=argv[i+1][0];
							temp_buffer[1]='\0';
							output_level=3-(atoi(temp_buffer));
							if(output_level < 0 || output_level > 3) {
								fprintf(stderr,"%s: %s\n",__progname,"invalid output value");
								usage();
							}
							i++;
						}													
						else usage();
						break;
					case 'f':
					case 'F':
						if(argv[i+1]) {
							if(strlen(argv[i+1]) > (MAX_FILENAME_LEN-2)) {
								fprintf(stderr,"%s: %s: %s\n",__progname,"config filename too long","recompile with larger MAX_FILENAME_LEN");
								exit(1);
							}
							sprintf(config_file,"%s",argv[i+1]);	
						}
						else if(argv[i][2]) {
							usage(); // -----------CHANGE ME--------------------
						}
						else usage();
						break;
					case 'u':
					case 'U':
						USERNAME_ONLY=1;
						break;
					case 'H':
					case 'h':
						usage();
					case 's':
					case 'S':
						SYS_CALL_CHECK=1;
						break;											
					default:
						fprintf(stderr,"%s: %s: %c\n",__progname,"invalid option",argv[i][1]);
						usage();
						break;
				}
			}	
		}
	}
	
	// read configuration into confread.h variables
	confread(config_file);
	
	if(xpassword_check) {
		if(xpassword_file_defined) {
			if(SYS_CALL_CHECK) sys_passwd_check(xpassword_file);
			else passwd_check(xpassword_file);
		}
		else {
			fprintf(stderr,"%s: %s: %s\n",__progname,"password file not defined","using /etc/passwd");
			if(SYS_CALL_CHECK) sys_passwd_check("/etc/passwd");
			else passwd_check("/etc/passwd");
		}
	}
	
	if(xgroup_check && xgroup_file_defined) {
		if(SYS_CALL_CHECK) sys_group_check(xgroup_file);
		else group_check(xgroup_file);
	}
	else {
		fprintf(stderr,"%s: %s: %s\n",__progname,"group file not defined","using /etc/group");
		if(SYS_CALL_CHECK) sys_group_check("/etc/group");
		group_check("/etc/group");
	}
	
	return 0;
}

void usage(void) {
	printf("%s: %s %s","usage",__progname,"[OPTION]...\n");
	printf("\t-v, --verbose\t\tverbose mode\n");
	printf("\t-o <n>\t\t\toutput level (0 <= n <= 3)\n");
 	printf("\t-f <filename>\t\tan alternative to /etc/sas.conf\n");
	printf("\t-u, --username_only\tprint first field only\n");
	printf("\t-V, --version\t\tprint version and exit\n");
	printf("\t-s, --system_calls\tuse system calls\n");
	printf("\t-h, --help\t\tdisplay this help and exit\n");
	printf("\nSee the sas(8) and sas.conf(8) man pages for more details.\n");
	exit(1);
}

void version(void) {
	printf("%s %s %s\n",__progname,"version",SAS_VERSION);
	exit(0);
}
