/*  sas - sane authentication scheme.
    Copyright (C) 2001 Quentin Sharpe <qsharpe@btinternet.com>.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
*/
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include "confread.h"
#include "global.h"

#define MAX_CONF_FILE_SIZE 5000

/*
 * Function to read in configuration file and set global variables.
 *
 * conf_string_cp[] exists to fix a bug - strstr(s1,s2) eats s1 (?!).
 *
 */
void confread(char *conf_file)
{
	FILE *conf;
	char *p, *temp, *q;
	char conf_string[1000];
	char conf_string_cp[1000];
	int i=0,x,y,z;
	
	xnum_allow_gid=0;
	xnum_allow_uid=0;
	
	if((conf=fopen(conf_file,"r"))==NULL) {
		fprintf(stderr,"%s: %s: %s\n",__progname,"error opening file",conf_file);
		exit(1);
	}
	
	while(!feof(conf)) {
                conf_string[i]=fgetc(conf);
		i++;
		if(i==MAX_CONF_FILE_SIZE-2) {
			fprintf(stderr,"%s: %s %s: %s\n",__progname,conf_file,"too big","recompile with larger MAX_CONF_FILE_SIZE");
			fclose(conf);
			exit(1);
		}
	}
	
	fclose(conf);
	conf_string[i-1]='\0';
	sprintf(conf_string_cp,"%s",conf_string);
	
	if((p=(char*)strstr(conf_string_cp,"$password_file")) != NULL) {
		p+=15;
		if(((temp)=(char*)strstr(p,"\n"))==NULL) {
			fprintf(stderr,"%s: %s %s\n",__progname,"syntax error in",conf_file);
			exit(1);
		}
		x=strlen(temp);
		y=strlen(p);
		z=y-x;
		p[z]='\0';
		if(z>=MAX_FILENAME_LEN-2) {
			fprintf(stderr,"%s: %s %s: %s\n",__progname,"filename too big in",conf_file,"recompile with larger MAX_FILENAME_LEN");
			exit(1);
		}
		xpassword_file_defined=1;
		sprintf(xpassword_file,"%s",p);
	}
	else {
		xpassword_file_defined=0;
	}
	
	sprintf(conf_string_cp,"%s",conf_string);	

	if((p=(char*)strstr(conf_string_cp,"$group_file")) != NULL) {
		p+=12;
		if(((temp)=(char*)strstr(p,"\n"))==NULL) {
			fprintf(stderr,"%s: %s %s\n",__progname,"syntax error in",conf_file);
			exit(1);
		}
		x=strlen(temp);
		y=strlen(p);
		z=y-x;
		p[z]='\0';
		if(z>=MAX_FILENAME_LEN-2) {
			fprintf(stderr,"%s: %s %s: %s\n",__progname,"filename too big in",conf_file,"recompile with larger MAX_FILENAME_LEN");
			exit(1);
		}
		xgroup_file_defined=1;
		sprintf(xgroup_file,"%s",p);
	}
	else {
		xgroup_file_defined=0;
	}
	
	sprintf(conf_string_cp,"%s",conf_string);		
		
	if((p=(char*)strstr(conf_string_cp,"$group_check")) != NULL) {
		p+=13;
		if(((temp)=(char*)strstr(p,"\n"))==NULL) {
			fprintf(stderr,"%s: %s %s\n",__progname,"syntax error in",conf_file);
			exit(1);
		}
		x=strlen(temp);
		y=strlen(p);
		z=y-x;
		p[z]='\0';
		if(z>=MAX_FILENAME_LEN-2) {
			fprintf(stderr,"%s: %s %s: %s\n",__progname,"syntax error in",conf_file,"check $group_check");
			exit(1);
		}
		x=atoi(p);
		if(x<0 || x>1) {				
			fprintf(stderr,"%s: %s %s: %s\n",__progname,"invalid value in",conf_file,"check $group_check");
			exit(1);
		}
		xgroup_check=x;
	}
	else {
		xgroup_check=0;
	}
	
	sprintf(conf_string_cp,"%s",conf_string);	
	
	if((p=(char*)strstr(conf_string_cp,"$password_check")) != NULL) {
		p+=16;
		if(((temp)=(char*)strstr(p,"\n"))==NULL) {
			fprintf(stderr,"%s: %s %s\n",__progname,"syntax error in",conf_file);
			exit(1);
		}
		x=strlen(temp);
		y=strlen(p);
		z=y-x;
		p[z]='\0';
		if(z>=MAX_FILENAME_LEN-2) {
			fprintf(stderr,"%s: %s %s: %s\n",__progname,"syntax error in",conf_file,"check $password_check");
			exit(1);
		}
		x=atoi(p);
		if(x<0 || x>1) {				
			fprintf(stderr,"%s: %s %s: %s\n",__progname,"invalid value in",conf_file,"check $password_check");
			exit(1);
		}
		xpassword_check=x;
	}
	else {
		xpassword_check=0;
	}
	
	sprintf(conf_string_cp,"%s",conf_string);	
	
	if((p=(char*)strstr(conf_string_cp,"$shadowed_passwords")) != NULL) {
		p+=20;
		if((temp=(char*)strstr(p,"\n"))==NULL) {
			fprintf(stderr,"%s: %s %s\n",__progname,"syntax error in",conf_file);
			exit(1);		
		}
		x=strlen(temp);
		y=strlen(p);
		z=y-x;
		p[z]='\0';
		if(z>=MAX_FILENAME_LEN-2) {
			fprintf(stderr,"%s: %s %s: %s\n",__progname,"syntax error in",conf_file,"check $shadowed_passwords");
			exit(1);
		}
		
		x=atoi(p);
		if(x > 1 || x < 0) {
			fprintf(stderr,"%s: %s %s: %s\n",__progname,"invalid value in",conf_file,"check $shadowed_passwords");
			exit(1);
		}
		xshadowed_passwords=x;
	}
	else {
		// assume shadowed passwords
		xshadowed_passwords=1;
	}
	
	sprintf(conf_string_cp,"%s",conf_string);	
	
	if((p=(char*)strstr(conf_string_cp,"$allow_gid(0)")) != NULL) {
		p+=14;
		if((temp=(char*)strstr(p,"\n"))==NULL) {
			fprintf(stderr,"%s: %s %s\n",__progname,"syntax error in",conf_file);
			exit(1);		
		}
		x=strlen(temp);
		y=strlen(p);
		z=y-x;
		p[z]='\0';
		if(z>=MAX_FILENAME_LEN-2) {
			fprintf(stderr,"%s: %s %s: %s\n",__progname,"syntax error in",conf_file,"check $allow_gid(0)");
			exit(1);
		}

		// parse list of aristocrats allowed gid 0
		q=strtok(p,",");
		sprintf(xallow_gid[xnum_allow_gid],"%s",q);
		xnum_allow_gid++;
		do {
			q=strtok('\0',",");
			if(q) {
				sprintf(xallow_gid[xnum_allow_gid],"%s",q);
				xnum_allow_gid++;
				if(xnum_allow_gid==MAX_ALLOW) {
					fprintf(stderr,"%s: %s: %s\n",__progname,"too many allowed gid users","recompile with larger MAX_ALLOW");
					exit(1);
				}
			}
		} while(q);
	}

	sprintf(conf_string_cp,"%s",conf_string);	
	
	if((p=(char*)strstr(conf_string_cp,"$allow_uid(0)")) != NULL) {
		p+=14;
		if((temp=(char*)strstr(p,"\n"))==NULL) {
			fprintf(stderr,"%s: %s %s\n",__progname,"syntax error in",conf_file);
			exit(1);		
		}
		x=strlen(temp);
		y=strlen(p);
		z=y-x;
		p[z]='\0';
		if(z>=MAX_FILENAME_LEN-2) {
			fprintf(stderr,"%s: %s %s: %s\n",__progname,"syntax error in",conf_file,"check $allow_uid(0)");
			exit(1);
		}

		// parse list of aristocrats allowed gid 0
		q=strtok(p,",");
		sprintf(xallow_uid[xnum_allow_uid],"%s",q);
		xnum_allow_uid++;
		do {
			q=strtok('\0',",");
			if(q) {
				sprintf(xallow_uid[xnum_allow_uid],"%s",q);
				xnum_allow_uid++;
				if(xnum_allow_uid==MAX_ALLOW) {
					fprintf(stderr,"%s: %s: %s\n",__progname,"too many allowed uid users","recompile with larger MAX_ALLOW");
					exit(1);
				}
			}
		} while(q);
	}
}
