#! /bin/sh


# The following two are the ANSI sequences for start and end embolden
case $TERM in
vt*|ansi*|con*|xterm*|linux*|screen*)
  S=[1m
  E=[m
  ;;
*)
  S=
  E=
  ;;
esac

PW_DIR=`pwd`

if test x$UID != x; then
  TRUST="--with-trusted=0,2,$UID"
else
  TRUST="--with-trusted=0,2"
fi

echo; echo "${S}__ STARTING TEST RUN STEALTH W/GPG STANDALONE __${E}"; echo;
echo Working directory: $PW_DIR

MAKE=`which gmake | sed -e "s%\([a-z:]\) .*%\1%g"` 
if test x$MAKE = x; then
	MAKE="make -s"
elif test x$MAKE = xno; then
	MAKE="make -s"
else
	if test "x$MAKE" = "xwhich:"; then
		MAKE="make -s"
	else
		MAKE="gmake -s"
	fi
fi
echo MAKE is $MAKE

# $GPG_PATH _must_ be an absolute path
# 
if test x${GPG_PATH} = x; then
    GPG_PATH=`which gpg | sed -e "s%\([a-z:]\) .*%\1%g"` 
fi

if test x${GPG_PATH} = x; then
    echo "ERROR: gpg (GnuPG) not found"
    exit
else
    GPG_OK=`echo ${GPG_PATH} | sed -e "s%\(^/.*\)%OK%g"`
    if test x${GPG_OK} = xOK; then
	echo "GPG_PATH is ${GPG_PATH}"
    else
	echo "ERROR: GPG_PATH (${GPG_PATH}) is _not_ an absolute path."
	echo 
	echo "  Apparently the command 'which gpg' did not yield an absolute path."
	echo "  You can fix the problem by setting the environment variable GPG_PATH"
	echo "  to the absolute path to gpg (GnuPG) and start the test again."
	exit
    fi
fi

echo

testrun1 ()
{
	#
	# test standalone compilation
	#
	echo "${S}Building standalone agent${E}"; echo;
	#
	if test -r "Makefile"; then
		$MAKE distclean
	fi
	#
	GPG_HASH=`gpg --load-extension tiger --print-md TIGER192 ${GPG_PATH}`
	#
	echo GPG_HASH is ${GPG_HASH}
	#
	./configure --quiet $TRUST --enable-debug --with-gpg=${GPG_PATH} --with-micro-stealth=137 --enable-login-watch --prefix=$PW_DIR --with-dataroot-prefix=$PW_DIR --with-config-file=$PW_DIR/testrc_1.signed  --with-checksum="${GPG_HASH}" 
	#
	if test x$? = x0; then
		echo "configure completed, exit status 0"; echo;
		$MAKE  > /dev/null
		if test x$? = x0; then
		    echo "$MAKE completed, exit status $?"; echo;
		else
		    echo "${S}ERROR:${E} make failed, exit status $?"; echo;
		    exit
		fi

	else
		echo "${S}ERROR:${E} configure failed, exit status $?"; echo;
		exit
	fi

	cp $PW_DIR/testrc_1 $PW_DIR/testrc_1.signed
	echo "--- You need to sign the config file testrc_1.signed now ---"
	echo
	gpg -a --clearsign $PW_DIR/testrc_1.signed
	mv $PW_DIR/testrc_1.signed.asc $PW_DIR/testrc_1.signed

	rm -f ./.samhain_file
	rm -f ./.samhain_log
	rm -f ./.samhain_lock

	./samhain -t init

	if test x$? = x0; then

		echo
		echo "--- You need to sign the database .samhain_file now ---"
		echo
		gpg -a --clearsign $PW_DIR/.samhain_file
		mv $PW_DIR/.samhain_file.asc $PW_DIR/.samhain_file

		./samhain -t check
		if test x$? = x0; then
		    echo "${S}check completed${E}"
		else
		    echo "${S}ERROR:${E} -- check -- failed, exit status $?"
		    echo
		    exit
		fi
	else
		echo "${S}ERROR:${E} -- init -- failed, exit status $?"; echo;
		exit
	fi
	    
}



	testrun1


echo; echo "${S}__ END TEST RUN STANDALONE __${E}"; echo;

exit

