#ifndef SH_EXTERN_H
#define SH_EXTERN_H

#if defined(WITH_EXTERNAL)

/* 
 * -- start a new external command, and add it to the list
 */ 
int sh_ext_setcommand(char * cmd);

/* 
 * -- clean up the command list
 */
int sh_ext_cleanup(void);

/*
 * -- set deadtime
 */
int sh_ext_deadtime (char * str);

/*
 * -- add keywords to the OR filter
 */
int sh_ext_add_or (char * str);

/*
 * -- add keywords to the AND filter
 */
int sh_ext_add_and (char * str);

/*
 * -- add keywords to the NOT filter
 */
int sh_ext_add_not (char * str);

/*
 * -- add keywords to the CL argument list
 */
int sh_ext_add_argv (char * str);

/*
 * -- add a path to the environment
 */
int sh_ext_add_default (char * str);

/*
 * -- add an environment variable
 */
int sh_ext_add_environ (char * str);

/*
 * -- define type
 */
int sh_ext_type (char * str);

/*
 * -- define checksum
 */
int sh_ext_checksum (char * str);

/*
 * -- choose privileges
 */
int sh_ext_priv (char * c);

/*
 * -- execute external script/program
 */
int sh_ext_execute (char t1, char t2, char t3, char * message, int msg_siz);

#endif

#endif
