/* SAMHAIN file system integrity testing                                   */
/* Copyright (C) 1999 Rainer Wichmann                                      */
/*                                                                         */
/*  This program is free software; you can redistribute it                 */
/*  and/or modify                                                          */
/*  it under the terms of the GNU General Public License as                */
/*  published by                                                           */
/*  the Free Software Foundation; either version 2 of the License, or      */
/*  (at your option) any later version.                                    */
/*                                                                         */
/*  This program is distributed in the hope that it will be useful,        */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of         */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          */
/*  GNU General Public License for more details.                           */
/*                                                                         */
/*  You should have received a copy of the GNU General Public License      */
/*  along with this program; if not, write to the Free Software            */
/*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              */


/* Public interface for error routines
 */
#ifndef SH_ERROR_H
#define SH_ERROR_H

/* Level of severity
 */
typedef enum {
  
  SH_ERR_ALL     = (1 << 0),  /* debug   */
  SH_ERR_INFO    = (1 << 1),  /* info    */
  SH_ERR_NOTICE  = (1 << 2),  /* notice  */
  SH_ERR_WARN    = (1 << 3),  /* warning */
  SH_ERR_STAMP   = (1 << 4),  /* mark    */
  SH_ERR_ERR     = (1 << 5),  /* error   */
  SH_ERR_SEVERE  = (1 << 6),  /* crit    */
  SH_ERR_FATAL   = (1 << 7),  /* alert   */

  SH_ERR_NOT     = (1 << 8),
  SH_ERR_INET    = (1 << 9),
  SH_ERR_MAX     = (1 << 9)
 } ShErrLevel;



enum {
  SH_ERR_T_START  = 0,

  /* 1-5 = SH_LEVEL_XXX */

  SH_ERR_T_RO     = SH_LEVEL_READONLY,
  SH_ERR_T_LOGS   = SH_LEVEL_LOGFILES,
  SH_ERR_T_GLOG   = SH_LEVEL_LOGGROW,
  SH_ERR_T_NOIG   = SH_LEVEL_NOIGNORE,
  SH_ERR_T_ALLIG  = SH_LEVEL_ALLIGNORE,
  SH_ERR_T_ATTR   = SH_LEVEL_ATTRIBUTES,  

  SH_ERR_T_DIR    = 9,
  SH_ERR_T_FILE   = 10,
  SH_ERR_T_NAME   = 11,

  SH_ERR_T_END    = 12
};


typedef struct  _errFlags {
  int           debug;
  int           HaveLog;

  int           loglevel;
  int           loglevel_temp;
  int           printlevel;
  int           maillevel;
  int           exportlevel;
  int           sysloglevel;
  int           externallevel;

  int           log_class;
  int           print_class;
  int           mail_class;
  int           export_class;
  int           syslog_class;
  int           external_class;

} blurb_errFlags;

extern int  ShDFLevel[SH_ERR_T_END];

/* set mask for message class
 */
int sh_error_log_mask (char * c);
int sh_error_print_mask (char * c);
int sh_error_mail_mask (char * c);
int sh_error_export_mask (char * c);
int sh_error_syslog_mask (char * c);
int sh_error_external_mask (char * c);


int sh_error_verify (char * s);
int sh_error_logverify (char * s);

void sh_error_dbg_on  (void);
void sh_error_dbg_off (void);

/* this function should be called to report an error
 */
void sh_error_handle (int flag, char * file, long line, long errnum, unsigned long  msg_index, ...);

/* only to stderr (GOOD/BAD)
 */
void sh_error_only_stderr (int flag);

/* set syslog facility 
 */
int  sh_log_set_facility (char * c);

/* define message header
 */
int sh_error_ehead (char * s);

/* convert a string to a numeric priority
 */ 
int sh_error_convert_level (char * str_s);

/* set level for error logging 
 */
int sh_error_setlog(char * str_s);

/* set severity levels
 */
int sh_error_set_iv (int iv, char *  severity_s);

/* set priorities
 */
int sh_error_set_level(char * str_s, int *facility);

/* set level for TCP export
 */
int sh_error_setexport(char *  str_s);

/* set level for syslog
 */
int sh_error_set_syslog (char * flag_s);

/* set level for printing
 */
int sh_error_setprint(char *  flag_s);

/* set severity for external
 */
int sh_error_set_external (char * str_s);


/* set level for mailing
 */
int sh_error_setseverity (char * flag);

/* set debug level
 */
int sh_error_setdebug (char * debug_s);

/* error messages
 */
char * sh_error_message (int tellme);

/* switch on/off log to file temporarily
 */
void sh_error_logoff(void);
void sh_error_logrestore(void);

/* (re)set the console device(s)
 */
int sh_log_set_console (char * address);
void reset_count_dev_console(void);

#ifdef WITH_MESSAGE_QUEUE
/* close the message queue
 */
void close_ipc (void);

/* enable message queue
 */
int enable_msgq(char * foo);
#endif
 
#endif
