
#include "config_xor.h"

#include "samhain.h"
#include "sh_error.h"

#include "sh_cat.h"

char * class_cat[] = {
  N_("AUD"),
  N_("PANIC"),
  N_("RUN"),
  N_("FIL"),
  N_("TCP"),
  N_("ERR"),
  N_("STAMP"),
  N_("ENET"),
  N_("EINPUT"),
  NULL
};

cat_entry msg_cat[] = {
  { MSG_EXIT_ABORTS, SH_ERR_FATAL,   PANIC, N_("msg=<PANIC>, program=<%s>, msg=<%s>, subroutine=<%s>")},
  { MSG_START_SRV,   SH_ERR_STAMP,   RUN,   N_("msg=<Server up, simultaneous connections: %d>, fd=<%d>")}, 
 
  { MSG_EXIT_ABORT1, SH_ERR_FATAL,   PANIC, N_("msg=<PANIC>, program=<%s>, msg=<Error initializing the application>")},
  { MSG_EXIT_NORMAL, SH_ERR_FATAL,   RUN,   N_("msg=<EXIT>, program=<%s>, status=<%s>")},
  { MSG_START_KEY,   SH_ERR_FATAL,   RUN,   N_("msg=<LOGKEY>, program=<%s>, hash=<%s>\n-----BEGIN LOGKEY-----\n%s%s")},
  { MSG_START_0H,    SH_ERR_FATAL,   RUN,   N_("msg=<START>, program=<%s>, user=<%ld>")},
  { MSG_START_1H,    SH_ERR_FATAL,   RUN,   N_("msg=<START>, program=<%s>, user=<%ld>, path=<%s>, hash=<%s>")},
  { MSG_START_2H,    SH_ERR_FATAL,   RUN,   N_("msg=<START>, program=<%s>, user=<%ld>, path=<%s>, hash=<%s>, path=<%s>, hash=<%s>")},
  { MSG_START_GH,    SH_ERR_FATAL,   RUN,   N_("msg=<START>, program=<%s>, user=<%ld>, path=<%s>, key_uid=<%s>, key_id=<%s>")},
  { MSG_START_GH2,   SH_ERR_FATAL,   RUN,   N_("msg=<EXIT>, program=<%s>, user=<%ld>, path=<%s>, key_uid=<%s>, key_id=<%s>, path=<%s>, key_uid=<%s>, key_id=<%s>")},


  { MSG_MLOCK,       SH_ERR_WARN,    RUN,   N_("msg=<Using insecure memory>")},
  { MSG_W_SIG,       SH_ERR_WARN,    RUN,   N_("msg=<%s>, subroutine=<sigaction>, signal=<%ld>")},
  { MSG_W_CHDIR,     SH_ERR_WARN,    RUN,   N_("msg=<%s>, subroutine=<chdir>, path=<%s>")},

  { MSG_MOD_FAIL,    SH_ERR_WARN,    RUN,   N_("msg=<Module not initialized>, obj=<%s>, return=<%ld>")},
  { MSG_MOD_OK,      SH_ERR_INFO,    RUN,   N_("msg=<Module initialized>, obj=<%s>")},
  { MSG_MOD_EXEC,    SH_ERR_ERR,     RUN,   N_("msg=<Module execution error>, obj=<%s>, return=<%ld>")},

  { MSG_RECONF,      SH_ERR_SEVERE,  RUN,   N_("msg=<Reconfiguration>")},
  { MSG_CHECK_0,     SH_ERR_WARN,    RUN,   N_("msg=<No files or directories to check>")},
  { MSG_CHECK_1,     SH_ERR_STAMP,   RUN,   N_("msg=<File check completed.>, time=<%ld>, kBps=<%f>")},
  { MSG_STAMP,       SH_ERR_STAMP,   RUN,   N_("msg=<---- TIMESTAMP ---->")},

  { MSG_D_START,     SH_ERR_INFO,    RUN,   N_("msg=<Downloading configuration file>")},
  { MSG_D_DSTART,    SH_ERR_INFO,    RUN,   N_("msg=<Downloading database file>")},
  { MSG_D_FAIL,      SH_ERR_INFO,    RUN,   N_("msg=<No file from server, trying local file>")},


#ifndef HAVE_URANDOM 
  { MSG_ENSTART,     SH_ERR_ALL,     RUN,   N_("msg=<Found entropy source>, path=<%s>")},
  { MSG_ENEXEC,      SH_ERR_ALL,     RUN,   N_("msg=<Execute entropy source>, path=<%s>, fd=<%ld>")},
  { MSG_ENFAIL,      SH_ERR_ALL,     RUN,   N_("msg=<Could not execute entropy source>, path=<%s>")},
  { MSG_ENTOUT,      SH_ERR_ALL,     RUN,   N_("msg=<Timeout in entropy collector>, time=<%ld>")},
  { MSG_ENCLOS,      SH_ERR_ALL,     RUN,   N_("msg=<No data from entropy source>, fd=<%ld>")},
  { MSG_ENCLOS1,     SH_ERR_ALL,     RUN,   N_("msg=<Close entropy source>, fd=<%ld>")},
  { MSG_ENREAD,      SH_ERR_ALL,     RUN,   N_("msg=<Data from entropy source>, fd=<%ld>, bytes=<%ld>")},
#endif

#ifdef SH_USE_SUIDCHK
  { MSG_SUID_POLICY, SH_ERR_SEVERE,  RUN,   N_("msg=<POLICY SUIDCHK  %s>, path=<%s>") },
  { MSG_SUID_STAT,   SH_ERR_ERR,     ERR,   N_("msg=<stat: %s>, path=<%s>") },
#endif

#ifdef SH_USE_KERN
  { MSG_KERN_POLICY, SH_ERR_SEVERE,  RUN,   N_("msg=<POLICY SYSCALL  kernel: %#lx map: %#lx>, obj=<%s>") },
#endif

#ifdef SH_USE_UTMP
  { MSG_UT_CHECK,    SH_ERR_INFO,    RUN,   N_("msg=<Checking logins>")},
  { MSG_UT_LG1A,     SH_ERR_INFO,    RUN,   N_("msg=<Login>, name=<%s>, tty=<%s>, host=<%s>, time=<%s>")},
  { MSG_UT_LG1B,     SH_ERR_INFO,    RUN,   N_("msg=<Login>, name=<%s>, tty=<%s>, time=<%s>")},
  { MSG_UT_LG2A,     SH_ERR_INFO,    RUN,   N_("msg=<Multiple login>, name=<%s>, tty=<%s>, host=<%s>, time=<%s>")},
  { MSG_UT_LG2B,     SH_ERR_INFO,    RUN,   N_("msg=<Multiple login>, name=<%s>, tty=<%s>, time=<%s>")},
  { MSG_UT_LG3A,     SH_ERR_INFO,    RUN,   N_("msg=<Logout>, name=<%s>, tty=<%s>, host=<%s>, time=<%s>")},
  { MSG_UT_LG3B,     SH_ERR_INFO,    RUN,   N_("msg=<Logout>, name=<%s>, tty=<%s>, time=<%s>")},
  { MSG_UT_LG3C,     SH_ERR_INFO,    RUN,   N_("msg=<Logout>, tty=<%s>, time=<%s>")},
  { MSG_UT_ROT,      SH_ERR_WARN,    RUN,   N_("msg=<Logfile size decreased>, path=<%s>")},

#endif

#if defined(SH_WITH_CLIENT) || defined(SH_STANDALONE)
  
  { MSG_FI_TOOLATE,  SH_ERR_ERR,     FIL,   N_("msg=<Large lstat/open overhead (%ld sec)>, path=<%s>")},
  { MSG_FI_CSUM,     SH_ERR_ALL,     FIL,   N_("msg=<Checksum>, chk=<%s>, path=<%s>")},
  { MSG_FI_DSUM,     SH_ERR_INFO,    FIL,   N_("msg=<d: %3ld, -: %3ld, l: %3ld, |: %3ld, s: %3ld, c: %3ld, b: %3ld>")},
  { MSG_FI_CHK,      SH_ERR_INFO,    FIL,   N_("msg=<Checking>, path=<%s>")},
  { MSG_FI_NULL,     SH_ERR_ERR,     FIL,   N_("msg=<Path is NULL>")},
  { MSG_FI_FAIL,     SH_ERR_ERR,     FIL,   N_("msg=<Check failed>, path=<%s>")},
  { MSG_FI_GLOB,     SH_ERR_ERR,     FIL,   N_("msg=<Globbing failed: %s>, path=<%s>")},
  { MSG_FI_COLL,     SH_ERR_WARN,    FIL,   N_("msg=<Modifyable object in tree>, path=<%s>, obj=<%s>")},
  { MSG_FI_2LONG,    SH_ERR_ERR,     FIL,   N_("msg=<Filename too long>, path=<%s>")},
  { MSG_FI_2LONG2,   SH_ERR_ERR,     FIL,   N_("msg=<Filename too long>, path=<%s/%s>")},
  { MSG_FI_NOPATH,   SH_ERR_ERR,     FIL,   N_("msg=<Filename not an absolute path>, path=<%s>")},
  { MSG_FI_DLNK,     SH_ERR_INFO,    FIL,   N_("msg=<Dangling link>, path=<%s>, obj=<%s>")},
  { MSG_FI_RDLNK,    SH_ERR_ERR,     FIL,   N_("msg=<%s>, subroutine=<readlink>, path=<%s>")},
  { MSG_FI_NOGRP,    SH_ERR_ERR,     FIL,   N_("msg=<No such group>, subroutine=<getgrgid>, group=<%ld>, path=<%s>")},
  { MSG_FI_NOUSR,    SH_ERR_ERR,     FIL,   N_("msg=<No such user>, subroutine=<getpwuid>, user=<%ld>, path=<%s>")},
  { MSG_FI_LSTAT,    SH_ERR_ERR,     FIL,   N_("msg=<%s>, subroutine=<lstat>, path=<%s>")},
  { MSG_FI_OBSC,     SH_ERR_ERR,     FIL,   N_("msg=<Obscure filename>, path=<%s>")},
  { MSG_FI_OBSC2,    SH_ERR_ERR,     FIL,   N_("msg=<Obscure filename>, path=<%s/%s>")},
  { MSG_FI_LIST,     SH_ERR_ALL,     FIL,   N_("msg=<%10s %2d %8s %8s %14ld %21s %s>")},
  { MSG_FI_LLNK,     SH_ERR_ALL,     FIL,   N_("msg=<   >>>  %10s  %s>")},
  { MSG_FI_MISS,     SH_ERR_ERR,     FIL,   N_("msg=<POLICY MISSING>, path=<%s>")},
  { MSG_FI_ADD,      SH_ERR_ERR,     FIL,   N_("msg=<POLICY ADDED>, path=<%s>")},
  { MSG_FI_CHAN,     SH_ERR_ERR,     FIL,   N_("msg=<POLICY %s>, path=<%s>, %s")},
  { MSG_FI_NODIR,    SH_ERR_ERR,     FIL,   N_("msg=<POLICY NODIRECTORY>, path=<%s>")},
  { MSG_FI_DBEX,     SH_ERR_WARN,    FIL,   N_("msg=<Signature database exists>, path=<%s>")},
#endif

  { MSG_TCP_NETRP,   SH_ERR_ERR,     TCP,   N_("msg=<Connection error: %s>, port=<%ld>, subroutine=<%s>")},

#ifndef SH_STANDALONE
  { MSG_TCP_MISMATCH,SH_ERR_ERR,     TCP,   N_("msg=<Protocol mismatch>")},
  { MSG_TCP_NONAME,  SH_ERR_ERR,     TCP,   N_("msg=<No server name known>")},
  { MSG_TCP_UNEXP,   SH_ERR_ERR,     TCP,   N_("msg=<Unexpected reply>")},
  { MSG_TCP_EFIL,    SH_ERR_ERR,     TCP,   N_("msg=<Could not open temporary file>")},
  { MSG_TCP_NOCONF,  SH_ERR_ERR,     TCP,   N_("msg=<Message delivery not confirmed>")},
  { MSG_TCP_NOAUTH,  SH_ERR_ERR,     TCP,   N_("msg=<Session key negotiation failed>")},
  { MSG_TCP_CONF,    SH_ERR_ALL,     TCP,   N_("msg=<Message delivery confirmed>")},
  { MSG_TCP_AUTH,    SH_ERR_INFO,    TCP,   N_("msg=<Session key negotiated>")},
  { MSG_TCP_FOK,     SH_ERR_INFO,    TCP,   N_("msg=<File download completed>")},
  { MSG_TCP_FBAD,    SH_ERR_ERR,     TCP,   N_("msg=<File download failed>")},
  { MSG_TCP_ECONN,   SH_ERR_ERR,     TCP,   N_("msg=<Connection error: %s>")},
  { MSG_TCP_EZERO,   SH_ERR_ERR,     TCP,   N_("msg=<Illegal zero reply>")},
  { MSG_TCP_EBGN,    SH_ERR_ERR,     TCP,   N_("msg=<Error in big integer library>")},

  { MSG_TCP_CREG,    SH_ERR_ALL,     TCP,   N_("msg=<Registered %s, salt %s, verifier %s>")},
  { MSG_TCP_FAUTH,   SH_ERR_INFO,    TCP,   N_("msg=<Force authentication>, client=<%s>")},
  { MSG_TCP_LOOKUP,  SH_ERR_SEVERE,  TCP,   N_("msg=<Peer name false>, client=<%s>, obj=<%s>")},
  { MSG_TCP_LOOKERR, SH_ERR_SEVERE,  TCP,   N_("msg=<Peer name not checked>, client=<%s>")},
  { MSG_TCP_LOOKERS, SH_ERR_SEVERE,  TCP,   N_("msg=<Peer resolves to unknown>, client=<%s>, obj=<%s>")},
  { MSG_TCP_TIMOUT,  SH_ERR_SEVERE,  TCP,   N_("msg=<Connection timeout>, client=<%s>")},
  { MSG_TCP_TIMEXC,  SH_ERR_SEVERE,  TCP,   N_("msg=<Time limit exceeded>, client=<%s>")},
  { MSG_TCP_NOCLT,   SH_ERR_SEVERE,  TCP,   N_("msg=<Hostname is NULL>")},
  { MSG_TCP_BADCONN, SH_ERR_SEVERE,  TCP,   N_("msg=<Invalid connection attempt (L%d)>, client=<%s>")},
  { MSG_TCP_FFILE ,  SH_ERR_SEVERE,  TCP,   N_("msg=<Unknown file request>, client=<%s>")},
  { MSG_TCP_NFILE ,  SH_ERR_SEVERE,  TCP,   N_("msg=<Requested file not found>, client=<%s>, path=<%s>")},
  { MSG_TCP_FINV ,   SH_ERR_SEVERE,  TCP,   N_("msg=<Invalid request in pass %d>, client=<%s>, obj=<%c%03o%c%03o%c%03o%c%03o>")},
  { MSG_TCP_OKFILE,  SH_ERR_INFO,    TCP,   N_("msg=<File transfer completed>, client=<%s>")},
  { MSG_TCP_OKMSG,   SH_ERR_ALL,     TCP,   N_("msg=<Message transfer completed>, client=<%s>")},
  { MSG_TCP_MSG,     SH_ERR_INET,    TCP,   N_("client=<%s>, msg=<%s>")},
  { MSG_TCP_NEW,     SH_ERR_NOTICE,  TCP,   N_("msg=<NEW CLIENT>, client=<%s>")},
  { MSG_TCP_ILL,     SH_ERR_SEVERE,  TCP,   N_("msg=<Restart without prior exit>, client=<%s>")},
  { MSG_TCP_SYNC,    SH_ERR_SEVERE,  TCP,   N_("msg=<Out of sync>, client=<%s>")},
  { MSG_TCP_RESET,   SH_ERR_SEVERE,  TCP,   N_("msg=<Connection reset by peer>, client=<%s>")},
  { MSG_TCP_CNEW,    SH_ERR_INFO,    TCP,   N_("msg=<New connection>, fd=<%d>")},
  { MSG_E_HTML,      SH_ERR_ERR,     ERR,   N_("msg=<Error writing HTML status>")},
#endif

  
  { MSG_E_AUTH,      SH_ERR_FATAL,   PANIC, N_("msg=<PANIC - File modified>, path=<%s>")},
  { MSG_ACCESS,      SH_ERR_FATAL,   PANIC, N_("msg=<PANIC - Access violation>, user=<%ld>, path=<%s>")},
  { MSG_TRUST,       SH_ERR_FATAL,   PANIC, N_("msg=<PANIC - Untrusted path>, user=<%ld>, path=<%s>")},
  { MSG_NOACCESS,    SH_ERR_FATAL,   PANIC, N_("msg=<PANIC - File not accessible>, user=<%ld>, path=<%s>")},
  { MSG_P_NODATA,    SH_ERR_FATAL,   PANIC, N_("msg=<PANIC - No data in file>, path=<%s>")},


#ifndef MEM_DEBUG
  { MSG_E_MNULL,     SH_ERR_ERR,     ERR,   N_("msg=<Dereferenced NULL pointer>")},
  { MSG_E_MMEM,      SH_ERR_ERR,     ERR,   N_("msg=<Out of memory>")},
#else
  { MSG_MSTAMP,      SH_ERR_STAMP,   STAMP, N_("msg=<Memory used:  max.=%ld, current=%ld>")},
  { MSG_MSTAMP2,     SH_ERR_STAMP,   STAMP, N_("msg=<Allocated Blocks: %d, Free'd Blocks: %d>")},
  { MSG_E_MNULL,     SH_ERR_ERR,     ERR,   N_("msg=<Dereferenced NULL pointer>, file=<%s>, line=<%d>")},
  { MSG_E_MMEM,      SH_ERR_ERR,     ERR,   N_("msg=<Out of memory>, file=<%s>, line=<%d>")},
  { MSG_E_MREC,      SH_ERR_ERR,     ERR,   N_("msg=<Free() on unrecorded block>, file=<%s>, line=<%d>")},
  { MSG_E_MOVER,     SH_ERR_ERR,     ERR,   N_("msg=<Memory overrun on block allocated in %s, line %d>, file=<%s>, line=<%d>")},
  { MSG_E_MUNDER,    SH_ERR_ERR,     ERR,   N_("msg=<Memory underrun on block allocated in %s, line %d>, file=<%s>, line=<%d>")},
  { MSG_E_NOTFREE,   SH_ERR_ERR,     ERR,   N_("Not deallocated: size %14ld>, file=<%19s>, line=<%d>")},
#endif

  { MSG_E_LSTAT,     SH_ERR_ERR,     ERR,   N_("msg=<%s>, subroutine=<lstat>, path=<%s>")},
  { MSG_E_TRUST,     SH_ERR_ERR,     ERR,   N_("msg=<Untrusted path>, user=<%ld>, path=<%s>")},
  { MSG_E_HASH,      SH_ERR_ERR,     ERR,   N_("msg=<Incorrect checksum>, path=<%s>")},
  { MSG_E_ACCESS,    SH_ERR_ERR,     ERR,   N_("msg=<File not accessible>, user=<%ld>, path=<%s>")},
  { MSG_E_READ,      SH_ERR_ERR,     ERR,   N_("msg=<Could not read file>, path=<%s>")},
  { MSG_NODEV,       SH_ERR_ERR,     ERR,   N_("msg=<Device not available>, user=<%ld>, path=<%s>")},
  { MSG_LOCKED,      SH_ERR_ERR,     ERR,   N_("msg=<File lock error>, user=<%ld>, path=<%s>, obj=<%s>")},
  { MSG_NOEXEC,      SH_ERR_ERR,     ERR,   N_("msg=<Could not execute file>, user=<%ld>, path=<%s>")},
  { MSG_ES_ENT,      SH_ERR_ERR,     ERR,   N_("msg=<No entropy collected>, subroutine=<%s>")},
  { MSG_ES_KEY1,     SH_ERR_ERR,     ERR,   N_("msg=<Insecure key generation>, subroutine=<%s>")},
  { MSG_ES_KEY2,     SH_ERR_ERR,     ERR,   N_("msg=<Error copying key>, subroutine=<%s>")},
  { MSG_E_GPG,       SH_ERR_ERR,     ERR,   N_("msg=<Checksum mismatch: need %s got %s>")},
  { MSG_E_SUBGEN,    SH_ERR_ERR,     ERR,   N_("msg=<%s>, subroutine=<%s>")},
  { MSG_E_SUBGPATH,  SH_ERR_ERR,     ERR,   N_("msg=<%s>, path=<%s>, subroutine=<%s>")},
  { MSG_E_UNLNK,     SH_ERR_ERR,     ERR,   N_("msg=<%s>, subroutine=<unlink>, path=<%s>")},
  { MSG_E_REGEX,     SH_ERR_ERR,     ERR,   N_("msg=<%s>, subroutine=<regcomp>, obj=<%s>")},
  { MSG_E_OPENDIR,   SH_ERR_ERR,     ERR,   N_("msg=<%s>, subroutine=<opendir>, path=<%s>")},
  { MSG_E_TRUST1,    SH_ERR_ERR,     ERR,   N_("msg=<%s>, subroutine=<trustfile>, path=<%s>")},
  { MSG_E_TRUST2,    SH_ERR_ERR,     ERR,   N_("msg=<%s>, subroutine=<trustfile>, path=<%s>, obj=<%s>")},
  { MSG_E_PWNULL,    SH_ERR_ERR,     ERR,   N_("msg=<Empty password file entry>, subroutine=<%s>, user=<%ld>, obj=<%s>")},
  { MSG_E_PWLONG,    SH_ERR_ERR,     ERR,   N_("msg=<Password file entry too long>, subroutine=<%s>, user=<%ld>, obj=<%s>")},
  { MSG_E_GRNULL,    SH_ERR_ERR,     ERR,   N_("msg=<Empty groups file entry>, subroutine=<%s>, group=<%ld>, obj=<%s>")},

  { MSG_E_NET,       SH_ERR_ERR,     ENET,  N_("msg=<%s>, subroutine=<%s>, service=<%s>, obj=<%s>")},
  { MSG_E_NETST,     SH_ERR_ERR,     ENET,  N_("msg=<Invalid connection state>, expect=<%4s>, received=<%4s>")},
  { MSG_E_NETST1,    SH_ERR_ERR,     ENET,  N_("msg=<Invalid connection state>, expect=<%4s>, received=<%4s>, address=<%s>")},
  { MSG_E_NETRP,     SH_ERR_ERR,     ENET,  N_("msg=<%s>, fd=<%ld>, subroutine=<%s>")},
  { MSG_E_NLOST,     SH_ERR_ERR,     ENET,  N_("msg=<Connection failure>, service=<%s>, obj=<%s>")},
  { MSG_E_NEST,      SH_ERR_ERR,     ENET,  N_("msg=<Connection reestablished>, service=<%s>, obj=<%s>")},

  { MSG_EINVALS,     SH_ERR_ERR,     EINPUT,N_("msg=<Invalid input>, option=<%s>, obj=<%s>")},
  { MSG_EINVALL,     SH_ERR_ERR,     EINPUT,N_("msg=<Invalid input>, option=<%s>, obj=<%ld>")},
  { MSG_EINVALD,     SH_ERR_ERR,     EINPUT,N_("msg=<Unmatched @end>, option=<%s>, obj=<%ld>")},
  { MSG_EINVALDD,    SH_ERR_ERR,     EINPUT,N_("msg=<Missing @end>, option=<%s>, obj=<%ld>")},

  { MSG_SRV_FAIL,    SH_ERR_ERR,     ERR,   N_("msg=<Service failure>, service=<%s>, obj=<%s>")},


  { MSG_AUD_OPEN,    SH_ERR_NOTICE,  AUD,   N_("interface=<open>, pathname=<%s>, oflag=<%ld>, mode=<%ld>, return_id=<%ld>")},
  { MSG_AUD_DUP,     SH_ERR_NOTICE,  AUD,   N_("interface=<dup>, file_id=<%s>, return_id=<%ld>")},
  { MSG_AUD_PIPE,    SH_ERR_NOTICE,  AUD,   N_("interface=<pipe>, rd_file_id=<%s>, wr_file_id=<%ld>")},
  { MSG_AUD_FORK,    SH_ERR_NOTICE,  AUD,   N_("interface=<fork>, return_id=<%ld>")},
  { MSG_AUD_EXIT,    SH_ERR_NOTICE,  AUD,   N_("interface=<exit>, exit_code=<%ld>")},
  { MSG_AUD_SETUID,  SH_ERR_NOTICE,  AUD,   N_("interface=<setuid>, uid=<%ld>")},
  { MSG_AUD_SETGID,  SH_ERR_NOTICE,  AUD,   N_("interface=<setgid>, gid=<%ld>")},
  { MSG_AUD_UTIME,   SH_ERR_NOTICE,  AUD,   N_("interface=<utime>, pathname=<%s>, atime=<%ld>, mtime=<%ld>")},
  { MSG_AUD_EXEC,    SH_ERR_NOTICE,  AUD,   N_("interface=<exec>, pathname=<%s>, uid=<%ld>, gid=<%ld>")},
  { MSG_AUD_CHDIR,   SH_ERR_NOTICE,  AUD,   N_("interface=<chdir>, pathname=<%s>")},
  { MSG_AUD_UNLINK,  SH_ERR_NOTICE,  AUD,   N_("interface=<unlink>, pathname=<%s>")},
  { MSG_AUD_KILL,    SH_ERR_NOTICE,  AUD,   N_("interface=<kill>, pid=<%ld>, sig=<%ld>")},
  { 0, 0, 0, NULL}
};






