#ifndef SH_CALLS_H
#define SH_CALLS_H

#define  AUD_CHDIR  (1UL <<  0)
#define  AUD_CHMOD  (1UL <<  1)
#define  AUD_CHOWN  (1UL <<  2)
#define  AUD_CREAT  (1UL <<  3)
#define  AUD_DUP    (1UL <<  4)
#define  AUD_EXEC   (1UL <<  5)
#define  AUD_EXIT   (1UL <<  6)
#define  AUD_FORK   (1UL <<  7)
#define  AUD_KILL   (1UL <<  8)
#define  AUD_LINK   (1UL <<  9)
#define  AUD_MKDIR  (1UL << 10)
#define  AUD_MKFIFO (1UL << 11)
#define  AUD_OPEN   (1UL << 12)
#define  AUD_PIPE   (1UL << 13)
#define  AUD_RENAME (1UL << 14)
#define  AUD_RMDIR  (1UL << 15)
#define  AUD_SETGID (1UL << 16)
#define  AUD_SETUID (1UL << 17)
#define  AUD_UNLINK (1UL << 18)
#define  AUD_UTIME  (1UL << 19)

#include <sys/types.h>
#include <sys/stat.h>
#include <sys/socket.h>
#include <signal.h>
#include <utime.h>

/* Set aud functions
 */
int sh_aud_set_functions(char * str_s);


long int retry_accept(int fd, struct sockaddr *serv_addr, int * addrlen);
long int retry_stat (const char *file_name, struct stat *buf);
long int retry_fstat(int filed,             struct stat *buf);
long int retry_lstat(const char *file_name, struct stat *buf);
long int retry_sigaction(int signum,  const  struct  sigaction  *act,
			 struct sigaction *oldact);
long int retry_fcntl(int fd, int cmd, long arg);
long int retry_connect(int fd, struct sockaddr *serv_addr, int addrlen);

long int retry_aud_dup2    (char * file, int line, int fd, int fd2);
long int retry_aud_execve  (char * file, int line, 
			    const  char *dateiname, char * argv[],
			    char *envp[]);
long int retry_aud_dup     (char * file, int line, 
			    int fd);
long int retry_aud_chdir   (char * file, int line, 
			    const char *path);
long int retry_aud_unlink  (char * file, int line, 
			    char * path);
long int retry_aud_utime   (char * file, int line, 
			    char * path, struct utimbuf *buf);

long int aud_open   (char * file, int line, int privs,
		     const char *pathname, int flags, mode_t mode);
long int aud_dup    (char * file, int line, int fd);
void     aud_exit   (char * file, int line, int fd);
void     aud__exit  (char * file, int line, int fd);
pid_t    aud_fork   (char * file, int line);
int      aud_pipe   (char * file, int line, int modus[2]);
int      aud_setuid (char * file, int line, uid_t uid);
int      aud_setgid (char * file, int line, gid_t gid);
long int aud_kill   (char * file, int line, pid_t pid, int sig);

#endif 
