/* 
 * need to #define SH_USE_KERN
 *
 */

#include "config.h"

#ifdef SH_USE_KERN

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <errno.h>
#include <limits.h>
#include <sys/utsname.h>


#define SH_MAXCALLS 512

#include "kern_head.h"


typedef struct _smap_entry {
  unsigned long addr;
  char          name[64];
} smap_entry;



int fill_smap(smap_entry * sh_smap, int num)
{
  FILE * fp;
  char buf[512], addr[16], name[128];
  int  i, j, count = 0;

  fp = fopen (SYSTEMMAP, "r");

  if (!fp)
    {
      fprintf(stderr, "error opening <%s>\n", SYSTEMMAP);
      perror("fill_smap: fopen");
      return -1;
    }

  while (fgets(buf, 512, fp) != NULL)
    {

      if (buf[9] != 'T')
	continue;
      if ( (buf[11]!='s' || buf[12]!='y' || buf[13]!='s' || buf[14]!='_') &&
	   (buf[11]!='o' || buf[12]!='l' || buf[13]!='d' || buf[14]!='_'))
	continue;

      for (i = 0; i < num; ++i)
	{
	  for (j = 0; j < 128; ++j)
	    {
	      if (buf[11+j] == '\n' || buf[11+j] == '\0')
		{
		  name[j] = '\0';
		  break;
		}
	      name[j] = buf[11+j];
	    }


	  if (0 == strcmp(name, sh_smap[i].name)) 
	    {
      
	      /* --- copy symbol address ---
	       */
	      addr[0] = '0'; addr[1] = 'x'; addr[2] = '\0';
	      strncat(&addr[2], buf, 8);
	      addr[10] = '\0';
	      sh_smap[i].addr = strtoul(addr, NULL, 0);
	      if (sh_smap[i].addr == ULONG_MAX)
		{
		  perror("fill_smap");
		  return -1;
		}

	      ++count;
	      /* break; */
      	    }
	}
    }
  fclose(fp);
  return count;
}


int main()
{
  int i, count;
  int which;
  smap_entry sh_smap[SH_MAXCALLS];
  struct utsname utbuf;

  if (0 != uname(&utbuf))
    {
      perror("kern_head: utname");
      exit (EXIT_FAILURE);
    }

  if      (strncmp(utbuf.release, "2.2", 3) == 0)
    which = 2;
  else if (strncmp(utbuf.release, "2.4", 3) == 0)
    which = 4;
  else
    {
      printf("kern_head: kernel %s not supported\n", utbuf.release);
      exit (EXIT_FAILURE);
    }
  
  if (utbuf.machine[0] != 'i' || utbuf.machine[2] != '8' || 
      utbuf.machine[3] != '6')
    {
      printf("kern_head: machine %s not supported\n", utbuf.machine);
      exit (EXIT_FAILURE);
    }


  printf("#ifndef SH_KERN_CALLS_H\n");
  printf("#define SH_KERN_CALLS_H\n\n");

  printf("\n/* Kernel %s, machine %s -- use table %s */\n\n", 
	 utbuf.release, utbuf.machine,
	 (which == 2) ? "callz_2p2" : "callz_2p4");
      

  for (i = 0; i < SH_MAXCALLS; ++i)
    {
      if (which == 2)
	{
	  if (callz_2p2[i] == NULL)
	    break;
	  strcpy(sh_smap[i].name, callz_2p2[i]);
	}
      else
	{
	  if (callz_2p4[i] == NULL)
	    break;
	  strcpy(sh_smap[i].name, callz_2p4[i]);
	}
      sh_smap[i].addr    = 0UL;
    }

  count = i;

  if ( fill_smap(sh_smap, count) < 0)
    exit (EXIT_FAILURE);

  printf("#define SH_MAXCALLS %d\n\n", count);

  printf("typedef struct _sh_syscall_t {\n");
  printf("  unsigned long addr;\n");
  printf("  char *        name;\n");
  printf("} sh_syscall_t;\n\n");

  printf("static sh_syscall_t sh_syscalls[] = {\n");

  for (i = 0; i < count; ++i) 
    {
      printf(" /* %03d */   { %#lx, N_(%c%s%c) },\n", 
	     i, sh_smap[i].addr, '"', sh_smap[i].name, '"');
    }
  printf(" /* eof */   { 0x00000000,  NULL }\n");
  printf("};\n\n");

  printf("#endif\n");

  exit (EXIT_SUCCESS);
}

/* #ifdef SH_USE_KERN */
#else

#include <stdio.h>
#include <stdlib.h>

int main()
{
  printf("#ifndef SH_KERN_CALLS_H\n");
  printf("#define SH_KERN_CALLS_H\n\n");

  printf("/* Dummy header. */\n\n");

  printf("typedef struct _sh_syscall_t {\n");
  printf("  unsigned long addr;\n");
  printf("  char *        name;\n");
  printf("} sh_syscall_t;\n\n");

  printf("#endif\n");

  return (EXIT_SUCCESS);
}

/* #ifdef SH_USE_KERN */
#endif
