#include <string.h>
#include <syslog.h>
#include <netdb.h>
#include <stdio.h>
#include <stdlib.h>
#include <netinet/in.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/resource.h>
#include <sys/stat.h>
#include <sys/wait.h>
#include <dirent.h>
#include <fcntl.h>
#include <unistd.h>

const char *copyright="pttyd, The Pseudo-tty Daemon, copyright May 1997, Greg Alexander.  To be distributed under the terms of the GNU General Public License, included in the file COPYING.\n";


void childh(int sig)
{
	signal(SIGCHLD,childh);
	wait3(NULL,WNOHANG,NULL);
}

int get_sock(int s);

int main(int argc,char *argv[])
{
	int s,i;
	struct sockaddr_in sin;
	struct servent *se=getservbyname("pttyd","tcp");
	
	if (getuid())
		return fprintf(stderr,"Need root!!");
	if ((s=socket(AF_INET,SOCK_STREAM,0))==-1)
		return perror("socket"),1;
	sin.sin_family=AF_INET;
	sin.sin_port=se->s_port;
	sin.sin_addr.s_addr=htonl(INADDR_ANY);
	if (bind(s,(struct sockaddr *)&sin,sizeof(struct sockaddr_in)))
		return perror("bind"),1;
	if (listen(s,4))
		return perror("listen"),1;
	openlog("pttyd",LOG_PID,LOG_DAEMON);
	close(0); close(1); close(2);
	if (fork())
		return 1;
	i=sizeof(struct sockaddr_in);
	signal(SIGCHLD,childh);
	while (get_sock(accept(s,(struct sockaddr *)&sin,&i))) {
		wait3(NULL,WNOHANG,NULL);
		wait3(NULL,WNOHANG,NULL);
		wait3(NULL,WNOHANG,NULL);
		wait3(NULL,WNOHANG,NULL);
	}
	close(s);
	return 0;
}

void alarmh(int sig) {
	syslog(LOG_NOTICE,"timed out waiting for data.\n");
	exit(0);
}

int check_pid_owns_pty(pid_t pid,char *ptyname,uid_t uid) {
	struct stat s1,s2;
	char s[100];
	DIR *d;
	struct dirent *de;
	sprintf(s,"/proc/%d/fd",pid);
	if (!(d=opendir(s)))
		return syslog(LOG_NOTICE,"opendir(\"%s\"): %m\n",s),0;
	if (chdir(s))
		return syslog(LOG_NOTICE,"chdir(\"%s\"): %m\n",s),0;
	stat(ptyname,&s1);
	while ((de=readdir(d))) {
		if (stat(de->d_name,&s2)) {
			syslog(LOG_NOTICE,"stat failed (%m): %s!\n",de->d_name);
			continue;
		}
/*		syslog(LOG_DEBUG,"%s: %d (%d)\n",de->d_name,s2.st_ino,s1.st_ino); */
		if (s1.st_dev==s2.st_dev && s1.st_ino==s2.st_ino)
			return syslog(LOG_INFO,"request for %s by %d (pid: %d) verified.\n",ptyname,uid,pid),closedir(d),1;
	}
	syslog(LOG_NOTICE,"request for %s by %d (pid: %d) -denied-!\n",ptyname,uid,pid);
	closedir(d);
	return 0;
}

uid_t getuidfrompid(pid_t pid, char *ptyname)
{
	char s[1000];
	FILE *f;
	sprintf(s,"/proc/%d/status",pid);
	f=fopen(s,"r");
	if (!f) {
		syslog(LOG_NOTICE,"got a bad request for %s for a non-existant pid: %d\n",ptyname,pid);
		exit(0);
	}
	while (fgets(s,999,f)) {
		s[999]=0;
		if (!strncasecmp(s,"Uid:",4))
			return atoi(s+5);
	}
	syslog(LOG_NOTICE,"no \"Uid:\" line for pid %d which requested %s!\n",(int)pid,ptyname);
	exit(0);
} 

int get_sock(int s)
{
	char ss[10],ptyname[100],ttyname[100];
	int i;
	pid_t pid;
	uid_t uid;
	
	if (s<0)
		return s;
	if (fork())
		return close(s),1;
	signal(SIGALRM,alarmh);
	alarm(30);
	for (i=7;i>0;i-=read(s,ss,i)) ; /* Grabs 7 bytes from socket s */
	alarm(0);
	ss[7]=0;
	sprintf(ptyname,"/dev/pty%s",ss+5);
	sprintf(ttyname,"/dev/tty%s",ss+5);
	pid=atoi(ss);
	uid=getuidfrompid(pid,ptyname);
	if (!check_pid_owns_pty(pid,ptyname,uid))
		goto done;
	chown(ttyname,uid,-1);
	write(s,"OK!\n",4);
done:
	close(s);
	exit(0);
}