#include <netdb.h>
#include <stdio.h>
#include <stdlib.h>
#include <netinet/in.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/stat.h>
#include <dirent.h>
#include <fcntl.h>
#include <unistd.h>

int get_ptty(char *ptyname)
{
	int s;
	char ss[10];
	struct sockaddr_in sin;
	struct servent *se=getservbyname("pttyd","tcp");

	if (!se)
		return fprintf(stderr,"No tcp/pttyd entry in /etc/services!\n"),0;
	if ((s=socket(AF_INET,SOCK_STREAM,0))==-1)
		return perror("socket"),0;
	sin.sin_family=AF_INET;
	sin.sin_port=se->s_port;
	sin.sin_addr.s_addr=htonl(0x7f000001);
	if (connect(s,&sin,sizeof(struct sockaddr_in)))
		return perror("connect"),0;
	sprintf(ss,"%05d%s\n",getpid(),ptyname+strlen(ptyname)-2);
	write(s,ss,8);
	if (read(s,ss,4))
		return close(s),1;
	else
		return close(s),0;
}
