/*
 * Copyright 1999, Alexander Feldman <alex@varna.net>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Alexander Feldman nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY ALEXANDER FELDMAN AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL ALEXANDER FELDMAN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef __SERVER_HPP__
#define __SERVER_HPP__

#include "keeper.hpp"

void server(int, char *);
bool get_failed_servers(int, CStringArray *);

bool check_gecos_field(char *);
bool change_password(char *, char *, int, int, int, int);
bool change_gecos(char *, char *, char *, char *, char *, char *);
bool change_password_group(char *, char *);

bool delete_group(char *);
bool add_group(char *, char *, char *, unsigned int = (unsigned int)-1);
char *get_group(char *);
bool action_delete_group(int, char *, char *);
bool action_change_group_password(int, char *, char *);
void action_getkey(int);
bool action_change_password(int, char *, char *);
bool action_add_group(int, char *, char *);
bool action_chfn(int, char *, char *);
void action_get_group(int, char *);

bool action_add_user(int, char *, char *);
bool add_user(char *, char *, char *, char *, int, int);
bool check_shell(char *);
bool make_home(char *, char *, int, int);

bool action_delete_user(int, char *, char *);
bool delete_user(char *);
bool remove_tree(char *);

#endif // __SERVER_HPP__
