/*
 * Copyright 1999, Alexander Feldman <alex@varna.net>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Alexander Feldman nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY ALEXANDER FELDMAN AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL ALEXANDER FELDMAN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef __PASSWDD_HPP__
#define __PASSWDD_HPP__

#include <signal.h>
#include <stdlib.h>
#include <string.h>
#include <syslog.h>
#include <unistd.h>
#include <netdb.h>
#include <stdio.h>
#include <errno.h>
#include <sys/wait.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/ipc.h>
#include <sys/sem.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#ifdef DEBUG
# include <stdarg.h>
#endif

#include "config.h"
#include "database.hpp"
#include "inetaddr.hpp"
#include "version.hpp"
#include "globals.hpp"
#include "pidfile.hpp"
#include "strings.hpp"
#include "getarg.h"
#include "server.hpp"
#include "sockio.hpp"
#include "conf.hpp"
#include "rsa.hpp"

#ifdef _SEM_SEMUN_UNDEFINED
// according to X/OPEN we have to define it ourselves
union semun {
	int val;                    // value for SETVAL
	struct semid_ds *buf;       // buffer for IPC_STAT, IPC_SET
	unsigned short int *array;  // array for GETALL, SETALL
	struct seminfo *__buf;      // buffer for IPC_INFO
};
#endif

#ifdef _SOCKLEN_T_UNDEFINED
typedef int socklen_t;
#endif

// Function prototypes
extern bool AllowHost(struct in_addr);
extern void SignalProc(int);
extern void dprintf(char *, ...);

// Global variables
extern bool fgEncryptedPasswords;

extern CRSAKey *pRSAKey;

#endif // __PASSWDD_HPP__
