/*
 * Copyright 1999, Alexander Feldman <alex@varna.net>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Alexander Feldman nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY ALEXANDER FELDMAN AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL ALEXANDER FELDMAN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef __PASSWD_HPP__
#define __PASSWD_HPP__

#include <time.h>
#include <stdio.h>
#include <sys/types.h>

#include "config.h"
#include "entry.hpp"

// Structure definition
struct passwd
{
	char *pw_name;								// username
	char *pw_passwd;							// password
	uid_t pw_uid;								// user ID
	gid_t pw_gid;								// group ID
#ifdef ATT_CHANGE
	time_t pw_change;							// password change time
#endif // ATT_CHANGE
#ifdef ATT_CLASS
	char *pw_class;							// user access class
#endif // ATT_CLASS
#ifdef ATT_AGE
	char *pw_age;								// currently unused
#endif // ATT_AGE
#ifdef ATT_COMMENT	
	char *pw_comment;							// currently unused
#endif // ATT_COMMENT
	char *pw_gecos;							// Honeywell login info
	char *pw_dir;								// home directory
	char *pw_shell;							// shell program
#ifdef ATT_EXPIRE
	time_t pw_expire;							// account expiration
#endif // ATT_EXPIRE
	int pw_fields;								// fields filled in
};

class CPasswdEntry : public CEntry
{
	public:
		CPasswdEntry(FILE *);
		CPasswdEntry(char *, uid_t, gid_t, char *, char *, char *);
		~CPasswdEntry();
	
	public:
		char *GetName();
		char *GetPassword();
		char *GetGecos();
		char *GetHome();
		gid_t GetGroup();
		uid_t GetUser();
		bool SetPassword(char *, int, int, int, int);
		bool SetGecos(char *);
		bool PutEntry(FILE *);
	
		inline struct passwd *GetEntry() { return &strEntry; }

	private:
		static bool GetEntry(char *, void *);

	private:
		struct passwd strEntry;
};

#endif // __PASSWD_HPP__
