/*
 * Copyright 1999, Alexander Feldman <alex@varna.net>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Alexander Feldman nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY ALEXANDER FELDMAN AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL ALEXANDER FELDMAN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include <assert.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>

#include "config.h"
#include "obscure.hpp"
#include "getdef.hpp"

#ifdef HAVE_LIBCRACK
#ifdef HAVE_LIBCRACK_PW
	extern "C" char *FascistCheckPw();
#else
	extern "C" char *FascistCheck(char *, char *);
#endif
#endif

char *obscure(const char *pszOldPassword, const char *pszNewPassword, int fgSelfChange)
{
	char *pszDouble;
	char *pszCopy;
	register int i, j, k;
	int fgFlag;
#ifdef HAVE_LIBCRACK
	char *pszMsg = NULL;
	char *pszDictPath;
#endif
	
	assert(pszOldPassword);
	assert(pszNewPassword);
	
	if ('\0' == *pszNewPassword)
		return "no password";
	
// In case we change our own password we check wether it is similar to the
//	old one.	
	if (fgSelfChange) {
		if (0 == strcmp(pszOldPassword, pszNewPassword))
			return "no change";
		if (0 == strcasecmp(pszOldPassword, pszNewPassword))
			return "case changes only";
		pszDouble = (char *)malloc(strlen(pszOldPassword) * 2 + 1);
		pszCopy = (char *)malloc(strlen(pszNewPassword) + 1);
		if (!pszDouble || !pszCopy) {
			fprintf(stderr, "malloc failed\n");
			exit(13);
		}
		strcpy(pszDouble, pszOldPassword);
		strcat(pszDouble, pszOldPassword);
		strcpy(pszCopy, pszNewPassword);
		for (i = 0; pszDouble[i] != '\0'; i++)
			pszDouble[i] = tolower(pszDouble[i]);
		for (i = 0; pszCopy[i] != '\0'; i++)
			pszCopy[i] = tolower(pszCopy[i]);
		fgFlag = 0;
		if (strstr(pszDouble, pszCopy))
			fgFlag = 1;
		memset(pszDouble, 0, strlen(pszDouble));
		memset(pszCopy, 0, strlen(pszCopy));
		free(pszDouble);
		free(pszCopy);
		if (1 == fgFlag)
			return "rotated";
		for (i = j = 0; pszNewPassword[i] && pszOldPassword[i]; i++)
			if ((NULL != strchr(pszOldPassword, tolower(pszNewPassword[i]))) ||
				 (NULL != strchr(pszOldPassword, toupper(pszNewPassword[i]))))
				j += 1;
		if (i < j * 2)
			return "too similar";
	}
	for (i = j = 0; pszNewPassword[i] != '\0'; i++)
		if (isdigit(pszNewPassword[i]))
			j |= 1;
		else if (islower(pszNewPassword[i]))
	   	j |= 2;
		else if (isupper(pszNewPassword[i]))
	  		j |= 4;
		else
			j |= 8;
	for (i = 0, k = 9; i < 4; i++)
		if (0 != (j & (1 << i)))
			k -= 1;
	i = strlen(pszNewPassword);
	if (i < k)
		return "too simple";
	
	fgFlag = 1;
	for (j = 0; j < i; j++)
		if (pszNewPassword[j] != pszNewPassword[i - j - 1]) {
			fgFlag = 0;
			break;
		}
	if (fgFlag)
		return "a palindrome";
	
#if HAVE_LIBCRACK && LOGIN_DEFS
	if (NULL != (pszDictPath = getdef_str("CRACKLIB_DICTPATH")))
		pszMsg = FascistCheck((char *)pszNewPassword, (char *)pszDictPath);
	if (NULL != pszMsg)						// This check is to suppress compiler
		return pszMsg;						// warning.
#endif
	
	return NULL;
}
