/*
 * Copyright 1999, Alexander Feldman <alex@varna.net>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Alexander Feldman nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY ALEXANDER FELDMAN AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL ALEXANDER FELDMAN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef __ERRORS_H__
#define __ERRORS_H__

// Error codes for CEntry
#define NO_ERROR		 0
#define MEMORY_ERROR	 1
#define PARSE_ERROR		 2
#define FILE_ERROR		 3
#define EOF_ERROR		 4						// In fact this is no error

// More error codes for CConfigurationFile
#define OPEN_ERROR		 5 

// Additional error codes for CDatabase
#define STAT_ERROR		 6
#define FLUSH_ERROR	 	 7
#define READ_ERROR    	 8
#define WRITE_ERROR	 	 9
#define CHMOD_ERROR		10
#define CHOWN_ERROR		11
#define SYNC_ERROR		12
#define RENAME_ERROR	13
#define LOCK_ERROR		14
#define NOUSER_ERROR	15

// Additional error codes for CPidFile
#define UNLOCK_ERROR	15
#define PID_ERROR		16

#endif // __ERRORS_H__
