/*
 * Copyright 1999, Alexander Feldman <alex@varna.net>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Alexander Feldman nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY ALEXANDER FELDMAN AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL ALEXANDER FELDMAN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef __PUBLIC_HPP__
#define __PUBLIC_HPP__

#include "obn.hpp"
#include "sclio.hpp"

// Function Prototypes
extern bool scl_write_string(int, char *);
extern bool scl_match_string(int, char *);

class CAsymmetricKey
{
	public:
		virtual ~CAsymmetricKey();

	public:
		void WritePrivate(char *, bool = true);
		void WritePublic(char *, bool = true);
		void ReadPrivate(char *, bool = true);
		void ReadPublic(char *, bool = true);
		virtual void WritePrivateKey(int, bool = true) = 0;
		virtual void WritePublicKey(int, bool = true) = 0;
		virtual void ReadPrivateKey(int, bool = true) = 0;
		virtual void ReadPublicKey(int, bool = true) = 0;
};

class CAsymmetricBlock
{
	public:
		virtual ~CAsymmetricBlock();

	public:
		virtual void Encrypt() = 0;
		virtual void Decrypt() = 0;

	public:
		virtual void SetData(Byte *, Word) = 0;
		virtual Byte *GetData() = 0;
		virtual Word GetDataSize() = 0;
		virtual void Write(int) = 0;
		virtual void Read(int) = 0;
};

#endif // __PUBLIC_HPP__
