/*
 * Copyright 1999, Alexander Feldman <alex@varna.net>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Alexander Feldman nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY ALEXANDER FELDMAN AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL ALEXANDER FELDMAN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef __DER_HPP__
#define __DER_HPP__

#ifndef WIN32
# include "config.h"
#endif

#include "obn.hpp"
#include "sclio.hpp"
#include "errors.hpp"
#include "base64.hpp"

// The flags below are incomplete
#define ASN1_ID_PRIMITIVE		0x00
#define ASN1_ID_CONSTRUCTED		0x20
#define ASN1_TAG_INTEGER		0x02
#define ASN1_TAG_NULL			0x05
#define ASN1_TAG_SEQUENCE		0x10

class CDEREncodedSequence;

class CDEREncodedPrimitive
{
	public:
		CDEREncodedPrimitive();
		virtual ~CDEREncodedPrimitive();

	public:
		const Byte *GetType() const { return bType; };
		const Byte *GetLength() const { return bLength; };
		const Byte *GetValue() const { return pbValue; };
		Word GetTypeSize() const { return wTypeSize; };
		Word GetLengthSize() const { return wLengthSize; };
		Word GetValueSize() const { return wValueSize; };
		Word GetSize() const { return wTypeSize + wLengthSize + wValueSize; };
		void Write(int);
		void WriteBase64(int, bool = false);
		void Read(int);
		void ReadBase64(int);
		void FromSequence(CDEREncodedSequence &);

	protected:
		void EncodeLength(Word);
		Word DecodeLength();

	protected:
		Byte bType[16];
		Byte bLength[16];
		Byte *pbValue;

		Word wTypeSize;
		Word wLengthSize;
		Word wValueSize;
};

class CDEREncodedSequence : public CDEREncodedPrimitive
{
	friend CDEREncodedPrimitive;

	public:
		CDEREncodedSequence();
		~CDEREncodedSequence() { };

	public:
		void AddPrimitive(const CDEREncodedPrimitive &);

	private:
		Word wPointer;
};

class CDEREncodedBigNumber : public CBigNumber, public CDEREncodedPrimitive
{
	public:
		CDEREncodedBigNumber();
		CDEREncodedBigNumber(CDEREncodedSequence &);
		CDEREncodedBigNumber(const CBigNumber &);

	public:
		void Read(int);
};

#endif // __DER_HPP__
