/*
 * Copyright 1999, Alexander Feldman <alex@varna.net>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Alexander Feldman nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY ALEXANDER FELDMAN AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL ALEXANDER FELDMAN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef __CRYPTO_HPP__
#define __CRYPTO_HPP__

#ifdef WIN32
#define DWORDCONST(x)				(x##i64)
#define WORDCONST(x)				(x##L)
#else
#define DWORDCONST(x)				(x##LL)
#define WORDCONST(x)				(x##L)
#endif

#define BASE						DWORDCONST(0x100000000)
#define ONE							DWORDCONST(0x1)
#define MaxWORD						WORDCONST(0xFFFFFFFF)

#ifdef WIN32
	typedef unsigned __int32		Word;
	typedef unsigned __int64		Dword;
#else
	typedef unsigned int			Word;
	typedef unsigned long long		Dword;
#endif

typedef unsigned char				Byte;
typedef unsigned short				Short;

#define CHARSINWORD							8
#define BITSINWORD						   32
#define BITSINSHORT						   16
#define BITSINBYTE							8
#define BYTESINWORD					(BITSINWORD / BITSINBYTE)
#define BYTESINSHORT				(BITSINSHORT / BITSINBYTE)

// Operations for all types
#define Max(a, b)					((a) > (b) ? (a) : (b))
#define Min(a, b)					((a) < (b) ? (a) : (b))

// Operations with DWORDs
#define HiWORD(a)					((Word)((a) >> BITSINWORD))
#define LoWORD(a)					((Word)(a))
#define DWSHORT0(a)					((Short)((a) >> 48))
#define DWSHORT1(a)					((Short)((a) >> 32))
#define DWSHORT2(a)					((Short)((a) >> 16))
#define DWSHORT3(a)					((Short)(a))
#define DWBYTE0(a)					((Byte)((a) >> 56))
#define DWBYTE1(a)					((Byte)((a) >> 48))
#define DWBYTE2(a)					((Byte)((a) >> 40))
#define DWBYTE3(a)					((Byte)((a) >> 32))
#define DWBYTE4(a)					((Byte)((a) >> 24))
#define DWBYTE5(a)					((Byte)((a) >> 16))
#define DWBYTE6(a)					((Byte)((a) >> 8))
#define DWBYTE7(a)					((Byte)(a))
#define MAKEDWORD(a, b, c, d)		(((Dword)(a) << 48) | ((Dword)(b) << 32) | ((Dword)(c) << 16) | (Dword)(d))
#define MAKEDWORDB(a, b, c, d, e, f, g, h) \
									(((Dword)(a) << 56) | ((Dword)(b) << 48) | ((Dword)(c) << 40) | ((Dword)(d) << 32) | \
									 ((Dword)(e) << 24) | ((Dword)(f) << 16) | ((Dword)(g) << 8) | (Dword)(h))
#define REVERSEDWORD(a)				(((Dword)REVERSEWORD(LoWORD(a)) << BITSINWORD) | (REVERSEWORD(HiWORD(a))))

// Operations with WORDs
// The oldest byte is 0 (leftmost)
// The youngest byte is 3 (rightmost)
#define HISHORT(a)					((Short)((a) >> BITSINSHORT))
#define LOSHORT(a)					((Short)(a))
#define WBYTE0(a)					((Byte)((a) >> 24))
#define WBYTE1(a)					((Byte)((a) >> 16))
#define WBYTE2(a)					((Byte)((a) >> 8))
#define WBYTE3(a)					((Byte)(a))
#define MakeWord(a, b, c, d)		(((Word)(a) << 24) | ((Word)(b) << 16) | ((Word)(c) << 8) | (Word)(d))
#define MAKEWORDS(a, b)				(((Word)(a) << 16) | (Word)(b))
#define REVERSEWORD(a)				(((a) << 24) | ((a) >> 24) | (((a) & 0x0FF00) << 8) | (((a) & 0x0FF0000) >> 8))

// Operations with SHORTs
#define SBYTE0(a)					((Byte)((a) >> 8))
#define SBYTE1(a)					((Byte)(a))
#define MAKESHORT(a, b)				(((Short)(a) << 8) | (Short)(b))

// Bit operations with DWORDs
// Bit 0 is the least significant bit
// Bit 63 is the most significant bit
#define GETBIT(a, b)				(((a) >> (b)) & ONE)
#define SETBIT(a, b)				((a) = (a) | (ONE << (b)))
#define CLRBIT(a, b)				((a) = (a) & (~(ONE << (b))))
#define PUTBIT(a, b, c)				(((c) == 1) ? SETBIT((a), (b)) : CLRBIT((a), (b)))
#define STIRBITS(a, b, c, d)		{ d = 0; for (int ii = 0; ii < (b); ii++) PUTBIT((d), ii, GETBIT((a), (c)[ii])); }
#define MIRROR(a, b, c)				{ c = 0; for (int ii = 0; ii < (b); ii++) { c <<= 1; c |= (a >> ii) & 1; } }

// Bit operations with BYTEs
#define ROT2(a)						(((a) << 2) | (((a) >> 6) & 3))

#endif // __CRYPTO_HPP__
