/*
 * Copyright 1999, Alexander Feldman <alex@varna.net>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Alexander Feldman nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY ALEXANDER FELDMAN AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL ALEXANDER FELDMAN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include "rad64.hpp"

int _c64i(char c)
{
	if (c == '.')
		return 0;
	if (c == '/')
		return 1;
	if (c >= '0' && c <= '9')
		return c - '0' + 2;
	if (c >= 'A' && c <= 'Z')
		return c - 'A' + 12;
	if (c >= 'a' && c <= 'z')
		return c - 'a' + 38;
	return -1;
}

static unsigned char ito64c[] = "./0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";

int _i64c(int i)
{
	return ito64c[i];
}

char *_l64a(unsigned long l)
{
	static char szBuf[8];
	
	int i;
	for (i = 0; i < 6; i++)
		szBuf[i] = ito64c[(int)((l >> (i * 6)) % 64)];
	szBuf[i] = '\0';	

	return szBuf;
}

unsigned long _a64l(const char *pszString)
{
	unsigned long lValue = 0;
	unsigned long lShift = 0;

	for (int i = 0; i < 6 && *pszString; pszString++, lShift += 6)
		lValue += (_c64i(*pszString) << lShift);
	return lValue;
}
