%define version 0.11pl2

Summary: Secure password synchronization server and clients.
Name: passwdd
Version: %version
Release: 1
Copyright: GPL
Group: Networking/Utils
Source: passwdd-%version.tar.gz

%package libs
Summary: The passwddio library provides network security.
Group: Networking/Utilities

%package client
Summary: Console client for the passwdd package.
Group: Netowrking/Utilities
Requires: passwdd-libs

%package server
Summary: Server program for the passwdd package.
Group: Networking/Utilities
Requires: passwdd-libs

%package cgi
Summary: HTML CGI client for the passwdd package.
Group: Networking/Utilities
Requires: perl
Requires: passwdd-libs

%package doc
Summary: Documentation for the passwdd package.
Group: Networking/Utilities

%changelog
* Fri Mar 9 2001 Alexander Feldman <alex@varna.net>
- Updated to ver 0.11pl2
* Wed Aug 25 1999 Gianluca Granero <granero@usa.net>
- Updated to ver 0.06
* Tue Jun 8 1999 Jeremy Hansen <jeremy@xxedgexx.com>
- initial build of the rpm.

%description libs

The passwddio library provided basic network security. It
contains code for encrypted socket communication to prevent
plain text transmission of all passwords.

%description client
Client package for passwdd package.  This should be installed
on machines that want to update the master server.

%description server

Server package for passwdd package.  This should be installed
on machines that want to update the master server or act as a
master server.

%description doc

Documentation files for the passwdd package.

%description cgi

HTML CGI package for passwdd package.  This should be installed
on machines that want to update the master server via the web.

%description

This package contains the programs necessary to keep basic synchronization
among passwd/shadow files of a small network. There are server for UNIX and
clients for UNIX, windows and cgi client in PERL. You can give rights to a
certain users to add, delete and set passwords. Group passwords and adding 
and removing of groups is supported. Network chfn function.

%prep

%setup

%build
./configure --prefix=/usr \
            --sysconfdir=/etc \
            --with-cgi-dir=/home/httpd/cgi-bin/passwdd \
            --with-cgirel-dir=/cgi-bin/passwdd \
            --with-html-dir=/home/httpd/html/passwdd \
            --with-htmlrel-dir=/passwdd
make
cd cgi-clients/PasswddIO
perl Makefile.PL
make

%install
make install
install -m 755 -o root -g root server/passwdd.init /etc/rc.d/init.d/passwdd
cd cgi-clients/PasswddIO
make install

%files libs
%attr(755,root,root) /usr/lib/libpasswddio.so
%attr(755,root,root) /usr/lib/libpasswddio.so.0
%attr(755,root,root) /usr/lib/libpasswddio.so.0.0.0
%attr(644,root,root) /usr/lib/libpasswddio.la
%attr(644,root,root) /usr/lib/libpasswddio.a

%files doc
%doc AUTHORS
%doc COPYING 
%doc INSTALL
%doc README 
%doc NEWS
%doc docs/LSM

%files client
%attr(755,root,root) /usr/bin/passwdc_usradd
%attr(755,root,root) /usr/bin/passwdc_usrdel
%attr(755,root,root) /usr/bin/passwdc_grpadd
%attr(755,root,root) /usr/bin/passwdc_grpdel
%attr(755,root,root) /usr/bin/passwdc_chfn
%attr(755,root,root) /usr/bin/passwdc
%attr(644,root,root) %config /etc/passwdc.conf
%attr(644,root,root) /usr/man/man1/passwdc_usradd.1
%attr(644,root,root) /usr/man/man1/passwdc_usrdel.1
%attr(644,root,root) /usr/man/man1/passwdc_grpadd.1
%attr(644,root,root) /usr/man/man1/passwdc_grpdel.1
%attr(644,root,root) /usr/man/man1/passwdc_chfn.1
%attr(644,root,root) /usr/man/man1/passwdc.1
%attr(644,root,root) /usr/man/man5/passwdc.conf.5

%files server
%attr(644,root,root) %config /etc/passwdd.conf
%attr(755,root,root) /usr/sbin/passwdd
%attr(755,root,root) /usr/bin/rsakeys
%attr(755,root,root) /etc/rc.d/init.d/passwdd
%attr(644,root,root) /usr/man/man8/passwdd.8
%attr(644,root,root) /usr/man/man5/passwdd.conf.5
%attr(644,root,root) /usr/man/man1/rsakeys.1

%files cgi
%attr(644,root,root) %config /etc/passwdc.conf
%attr(755,root,root) /home/httpd/cgi-bin/passwdd/groupadd.pl
%attr(755,root,root) /home/httpd/cgi-bin/passwdd/groupdel.pl
%attr(755,root,root) /home/httpd/cgi-bin/passwdd/passwdc.pl
%attr(755,root,root) /home/httpd/cgi-bin/passwdd/passwdc_group.pl
%attr(755,root,root) /home/httpd/cgi-bin/passwdd/useradd.pl
%attr(755,root,root) /home/httpd/cgi-bin/passwdd/userchfn.pl
%attr(755,root,root) /home/httpd/cgi-bin/passwdd/userdel.pl
%attr(644,root,root) /home/httpd/html/passwdd/groupadd.html
%attr(644,root,root) /home/httpd/html/passwdd/groupadd_results.html
%attr(644,root,root) /home/httpd/html/passwdd/groupdel.html
%attr(644,root,root) /home/httpd/html/passwdd/groupdel_results.html
%attr(644,root,root) /home/httpd/html/passwdd/passwdc.html
%attr(644,root,root) /home/httpd/html/passwdd/passwdc_group.html
%attr(644,root,root) /home/httpd/html/passwdd/passwdc_results.html
%attr(644,root,root) /home/httpd/html/passwdd/services.html
%attr(644,root,root) /home/httpd/html/passwdd/useradd.html
%attr(644,root,root) /home/httpd/html/passwdd/useradd_results.html
%attr(644,root,root) /home/httpd/html/passwdd/userchfn.html
%attr(644,root,root) /home/httpd/html/passwdd/userchfn_results.html
%attr(644,root,root) /home/httpd/html/passwdd/userdel.html
%attr(644,root,root) /home/httpd/html/passwdd/userdel_results.html
%attr(644,root,root) /usr/man/man5/passwdc.conf.5
%attr(644,root,root) /usr/lib/perl5/site_perl/5.6.0/i386-linux/PasswddIO.pm
%attr(644,root,root) /usr/lib/perl5/site_perl/5.6.0/i386-linux/auto/PasswddIO/PasswddIO.bs
%attr(755,root,root) /usr/lib/perl5/site_perl/5.6.0/i386-linux/auto/PasswddIO/PasswddIO.so
%attr(644,root,root) /usr/lib/perl5/site_perl/5.6.0/i386-linux/auto/PasswddIO/autosplit.ix

%post server
chkconfig --level 2345 passwdd on
chkconfig --level 6 passwdd off
[ -d /var/spool/passwdd ] || mkdir /var/spool/passwdd
/usr/bin/rsakeys > /etc/passwdd.key
chmod 0400 /etc/passwdd.key

%post client
[ -d /var/spool/passwdc ] || mkdir /var/spool/passwdc

%post cgi
[ -d /var/spool/passwdc ] || mkdir /var/spool/passwdc

%preun server
chkconfig --del passwdd
