#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"

#include <passwddio.hpp>

MODULE = PasswddIO		PACKAGE = PasswddIO		

PROTOTYPES: DISABLE

static char *
ReadString(sockfd)
		int				sockfd
	PREINIT:
		char *data = NULL;
	CODE:
		if (-1 == read_string(sockfd, &data))
			XSRETURN_UNDEF;
		RETVAL = data;
	OUTPUT:
		RETVAL
	CLEANUP:
		if (NULL == data)
			free(data);

static int
ReadInteger(sockfd)
		int				sockfd
	PREINIT:
		int data;
	CODE:
		if (!read_integer(sockfd, &data))
			XSRETURN_UNDEF;
		RETVAL = data;
	OUTPUT:
		RETVAL

static char
ReadChar(sockfd)
		int				sockfd
	PREINIT:
		unsigned char data;
	CODE:
		if (!read_byte(sockfd, &data))
			XSRETURN_UNDEF;
		RETVAL = (char)data;
	OUTPUT:
		RETVAL

static char *
ReadPassword(sockfd)
		int				sockfd
	PREINIT:
		char password[128];
	CODE:
		if (!read_password(sockfd, password, sizeof(password)))
			XSRETURN_UNDEF;
		RETVAL = password;
	OUTPUT:
		RETVAL

static void *
ReadData(sockfd)
		int				sockfd
	PREINIT:
		void *data = NULL;
	CODE:
		if (-1 == read_data(sockfd, &data))
			XSRETURN_UNDEF;
		RETVAL = data;
	OUTPUT:
		RETVAL
	CLEANUP:
		if (NULL == data)
			free(data);

static int
WriteString(sockfd, data)
		int				sockfd
		char *			data
	CODE:
		RETVAL = write_string(sockfd, data);
	OUTPUT:
		RETVAL

static int
WriteInteger(sockfd, data)
		int				sockfd
		int				data
	CODE:
		RETVAL = write_integer(sockfd, data);
	OUTPUT:
		RETVAL

static int
WriteChar(sockfd, data)
		int				sockfd
		char			data
	CODE:
		RETVAL = write_byte(sockfd, (unsigned char)data);
	OUTPUT:
		RETVAL

static int
WriteData(sockfd, data, length)
		int				sockfd
		void *			data
		int				length
	CODE:
		RETVAL = write_data(sockfd, data, length);
	OUTPUT:
		RETVAL

static int
WritePassword(sockfd, data)
		int				sockfd
		char *			data
	CODE:
		RETVAL = write_password(sockfd, data);
	OUTPUT:
		RETVAL

static int
ReadLocalKey(name)
		char *			name
	CODE:
		RETVAL = read_local_key(name);
	OUTPUT:
		RETVAL

static int
RecvRemoteKey(sockfd, name)
		int				sockfd
		char *			name
	CODE:
		RETVAL = recv_remote_key(sockfd, name);
	OUTPUT:
		RETVAL

static int
SendLocalKey(sockfd)
		int				sockfd
	CODE:
		RETVAL = send_local_key(sockfd);
	OUTPUT:
		RETVAL

static void
DestroyLocalKey()
	CODE:
		destroy_local_key();

static void
DestroyRemoteKey()
	CODE:
		destroy_remote_key();
