dnl AC_CHECK_ENDIAN
dnl define either LITTLE_ENDIAN_HOST or BIG_ENDIAN_HOST
dnl
define(AC_CHECK_ENDIAN,
  [ if test "$cross_compiling" = yes; then
        AC_MSG_WARN(cross compiling; assuming little endianess)
    fi
    AC_MSG_CHECKING(endianess)
    AC_CACHE_VAL(ac_cv_c_endian,
      [ ac_cv_c_endian=unknown
        # See if sys/param.h defines the BYTE_ORDER macro.
        AC_TRY_COMPILE([#include <sys/types.h>
        #include <sys/param.h>], [
        #if !BYTE_ORDER || !BIG_ENDIAN || !LITTLE_ENDIAN
         bogus endian macros
        #endif], [# It does; now see whether it defined to BIG_ENDIAN or not.
        AC_TRY_COMPILE([#include <sys/types.h>
        #include <sys/param.h>], [
        #if BYTE_ORDER != BIG_ENDIAN
         not big endian
        #endif], ac_cv_c_endian=big, ac_cv_c_endian=little)])
        if test "$ac_cv_c_endian" = unknown; then
            AC_TRY_RUN([main () {
              /* Are we little or big endian?  From Harbison&Steele.  */
              union
              {
                long l;
                char c[sizeof (long)];
              } u;
              u.l = 1;
              exit (u.c[sizeof (long) - 1] == 1);
              }],
              ac_cv_c_endian=little,
              ac_cv_c_endian=big,
              ac_cv_c_endian=little
            )
        fi
      ])
    AC_MSG_RESULT([$ac_cv_c_endian])
    if test "$ac_cv_c_endian" = little; then
      AC_DEFINE(LITTLE_ENDIAN_HOST)
    else
      AC_DEFINE(BIG_ENDIAN_HOST)
    fi
  ])

define(AM_CONDITIONAL,
  [  AC_SUBST($1_TRUE)
     AC_SUBST($1_FALSE)
	 if $2; then
	 	$1_TRUE=
		$1_FALSE='#'
	else
		$1_TRUE='#'
		$1_FALSE=
	fi
  ])
		