/*
 * Copyright 1999, Alexander Feldman <alex@varna.net>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Alexander Feldman nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY ALEXANDER FELDMAN AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL ALEXANDER FELDMAN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef __SHADOW_HPP__
#define __SHADOW_HPP__

#include <time.h>
#include <stdio.h>
#include <sys/types.h>

#include "config.h"
#include "entry.hpp"

#define SECONDS_PER_DAY		(24L * 60L * 60L)

// Structure definition
struct spwd 
{
	char *sp_namp;								// login name
	char *sp_pwdp;								// encrypted password
	time_t sp_lstchg;							// date of last change
	time_t sp_min;								// minimum number of days between changes
	time_t sp_max;								// maximum number of days between changes
	time_t sp_warn;							// number of days of warning before password expires
	time_t sp_inact;							// number of days after password expires until the account becomes unusable
	time_t sp_expire;							// days since 1/1/70 until account expires
	unsigned long sp_flag;					// reserved for future use
};

class CShadowEntry : public CEntry
{
	public:
		CShadowEntry(FILE *);
		CShadowEntry(char *);
		~CShadowEntry();
	
	public:
		char *GetName();
		char *GetPassword();
		char *GetGecos() { return NULL; } 			// dummy
		char *GetHome() { return NULL; } 			// dummy	
		gid_t GetGroup() { return (gid_t)-1; }		// there is no group info in shadow file
		uid_t GetUser() { return (uid_t)-1;	}		// there is no user info in shadow file
		bool SetPassword(char *, int, int, int, int);
		bool SetGecos(char *) { return false; }	// dummy
		bool PutEntry(FILE *);
	
		inline struct spwd *GetEntry() { return &strEntry; }

	private:
		static bool GetEntry(char *, void *);

	private:
		struct spwd strEntry;
};

#endif // __SHADOW_HPP__
