/*
 * Copyright 1999, Alexander Feldman <alex@varna.net>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Alexander Feldman nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY ALEXANDER FELDMAN AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL ALEXANDER FELDMAN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef __KEEPER_HPP__
#define __KEEPER_HPP__

#include "strings.hpp"
#include "stdarg.h"

#define DIRECTION_IN					'<'
#define DIRECTION_OUT					'>'

#define PARAM_STRING					's'
#define PARAM_PASSWORD					'p'
#define PARAM_INTEGER					'i'
#define PARAM_BYTE						'b'
#define PARAM_PUBLICKEY					'k'

#define SEQUENCE_USER_PASSWORD			"<b<k>s>p<b>b>s>p>i>i>i>i<b"
#define SEQUENCE_GROUP_PASSWORD			"<b<k>s>p<b>b>s>p<b"
#define SEQUENCE_ADD_USER				"<b<k>s>p<b>b>s>s>s>s>i>i<b"
#define SEQUENCE_DEL_USER				"<b<k>s>p<b>b>s<b"
#define SEQUENCE_ADD_GROUP				"<b<k>s>p<b>b>s>s>s<b"
#define SEQUENCE_DELETE_GROUP			"<b<k>s>p<b>b>s<b"
#define SEQUENCE_CHFN					"<b<k>s>p<b>b>s>s>s>s>s>s<b"

class CKeeper
{
	public:
		CKeeper(CStringArray *, char *, ...);
		~CKeeper();
		bool Try();
		bool TryHost(int, char *, int);
	
	private:
		int iParams;
		char *pszSequence;
		void **ppvParameters;
		CStringArray *pHosts;
};

// Function prototypes
bool Postpone(CKeeper *);

#endif // __KEEPER_HPP__
