/*
 * Copyright 1999, Alexander Feldman <alex@varna.net>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Alexander Feldman nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY ALEXANDER FELDMAN AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL ALEXANDER FELDMAN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include <string.h>
#include <stdlib.h>
#include <assert.h>

#include "config.h"
#include "entry.hpp"

CEntry::CEntry(FILE *fpFile, void *pvTarget, size_t iBytes, PGetEntry pvfGetEntry)
{
	memset(pvTarget, 0, iBytes);
	
	iErrorCode = NO_ERROR;
	
	char *pszEntry = new char[MAX_ENTRY];
	if (NULL == pszEntry) {
		iErrorCode = MEMORY_ERROR;
		return;
	}
	if (!fgets(pszEntry, MAX_ENTRY, fpFile)) {
		iErrorCode = EOF_ERROR;
		delete pszEntry;
		return;
	}
	char *pszNewLine;
	if ((pszNewLine = strrchr(pszEntry, '\n')))
		*pszNewLine = '\0';
// Get some cleared memory for the shadow structure
	if (false == (*pvfGetEntry)(pszEntry, pvTarget))
		iErrorCode = PARSE_ERROR;

	delete pszEntry;
}

CEntry::CEntry()
{
	iErrorCode = NO_ERROR;
}

long CEntry::ToLong(char *pszEntry, long lDefault, bool *fgError)
{
	if ((NULL == pszEntry) || '\0' == pszEntry[0])
		return lDefault;
	char *pszInvalid;
	long lResult = strtol(pszEntry, &pszInvalid, 10);
	if ('\0' == *pszInvalid)				// We want the whole string to be valid
		return lResult;		
	*fgError = true;
	return lDefault;							// Field contains invalud characters	
}
