#ifndef __PASSWDDIO_HPP__
#define __PASSWDDIO_HPP__

#ifdef WIN32
# ifdef PASSWDDIO_EXPORTS
#  define PASSWDDIO_API __declspec(dllexport)
# else
#  define PASSWDDIO_API __declspec(dllimport)
# endif
#else
# define PASSWDDIO_API
#endif // WIN32

// Functions prototypes
extern PASSWDDIO_API int read_string(int, char *, int);
extern PASSWDDIO_API int read_string(int, char **);
extern PASSWDDIO_API int write_string(int, char *);
extern PASSWDDIO_API int read_integer(int, int *);
extern PASSWDDIO_API int write_integer(int, int);
extern PASSWDDIO_API int read_byte(int, unsigned char *);
extern PASSWDDIO_API int write_byte(int, unsigned char);
extern PASSWDDIO_API int read_data(int, void **);
extern PASSWDDIO_API int write_data(int, void *, int);
extern PASSWDDIO_API int read_password(int, char *, int);
extern PASSWDDIO_API int write_password(int, char *);

extern PASSWDDIO_API int read_local_key(char *);
extern PASSWDDIO_API int recv_remote_key(int, char *);
extern PASSWDDIO_API int send_local_key(int);
extern PASSWDDIO_API void destroy_local_key();
extern PASSWDDIO_API void destroy_remote_key();

#endif // __PASSWDDIO_HPP__
