/*
 * Copyright 1999, Alexander Feldman <alex@varna.net>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Alexander Feldman nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY ALEXANDER FELDMAN AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL ALEXANDER FELDMAN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef __MDC_HPP__
#define __MDC_HPP__

#include "crypto.hpp"
#include "digest.hpp"
#include "block.hpp"

class CDigestCipherKey : public CBlockKey
{
	public:
		CDigestCipherKey(CDigest &);
		CDigestCipherKey(CDigest &, const Byte *, Word = 0);

	public:
		const Byte *GetKey() const;

	public:
		virtual Word GetKeySize() { return cDigest.GetBlockSize(); };

	private:
		CDigest &cDigest;
		const Byte *bKey;
		Word wKeySize;
};

class CDigestCipherBlock : public CBlockObject
{
	public:
		CDigestCipherBlock(CDigest &);
		CDigestCipherBlock(CDigest &, const Byte *, Word = 0);

	public:
		virtual void Encrypt(const CBlockKey &cKey) { Encrypt((const CDigestCipherKey &)cKey); };
// MDC can be used only in CFB/OFB mode
		virtual void Decrypt(const CBlockKey &/*cKey*/) { /* dummy definition*/ };
		virtual void SetData(const Byte *, Word = 0);
		virtual Byte *GetData();
		virtual Word GetBlockSize() { return wBlockSize; };

	public:
		void Encrypt(const CDigestCipherKey &);

	private:
		CDigest &cDigest;
		Word wKeySize;
		Word wBlockSize;
};

#endif // __MDC_HPP__
